/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
import { defineStore } from 'pinia'
import AmetysFront from 'AmetysFront';
import { callMethod } from '@common/helper/ServerCommHelper.js';
import { transformToMember } from '@common/helper/MemberHelper.js';

/**
 * Pinia store for current project members, and searching users to add
 */
export const useSearchUsersStore = defineStore('searchUsers', {
  state: () => ({
        usersAndGroups: [],
        existingSearchData: null,
        finished: false,
        needReload: false 
    }),
  actions: {
    /**
     * Remove a member and edit projectMembers
     * @param {Number} limit The number of users to load
     * @param {String} criteria the criteria of the search
     * @param {Object} continueSearch True if the search is continued, so we need to use the existing search data
     */
    async searchUsersAndGroups(limit, criteria, continueSearch) {
        const searchStateName = 'search';
        this.finished = false;
        if(!continueSearch || this.existingSearchData != null)
        {
            console.log("Search users and groups with criteria: " + criteria);
            var results = await callMethod({
                role: 'org.ametys.plugins.workspaces.project.ProjectManager',
                methodName: 'searchUserByProject',
                parameters: [
                  AmetysFront.getAppParameter('projectName'),
                  limit,
                  criteria,
                  continueSearch ? this.existingSearchData : null
                ]
              });
              this.finished =  true;

              this.usersAndGroups = continueSearch ? this.usersAndGroups.concat(results.memberList.map(transformToMember)) : results.memberList.map(transformToMember);

              this.existingSearchData = results.searchData

              this.needReload = false;
        }
        
    }
  },
    getters: {
      isSearchFullyLoaded: state => {
          return this.finished;
      }
    }
})

