/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.activities.documents;

import java.util.Map;

import javax.jcr.RepositoryException;

import org.apache.commons.lang3.StringUtils;

import org.ametys.core.util.DateUtils;
import org.ametys.plugins.explorer.ObservationConstants;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;

/**
 * {@link ActivityType} implementation for the commenting of document
 */
public class DocumentCommentedActivityType extends ResourceCreatedOrUpdatedActivityType
{
    /** data name for storing the last modified date of the document */
    public static final String LAST_MODIFIED = "lastModified";
    /** data name for storing the last contributor of the document */
    public static final String LAST_CONTRIBUTOR = "lastContributor";
    /** data name for storing the comment */
    public static final String COMMENT_SUMMARY = "commentSummary";
    
    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException
    {
        super.setAdditionalActivityData(activity, parameters);
        
        String resourceId = (String) parameters.get(ObservationConstants.ARGS_ID);
        Resource resource = _resolver.resolveById(resourceId);
        activity.setValue(LAST_CONTRIBUTOR, resource.getLastContributor(), "user");
        activity.setValue(LAST_MODIFIED, DateUtils.asZonedDateTime(resource.getLastModified()), "datetime");
        
        String comment = (String) parameters.get(org.ametys.plugins.workspaces.ObservationConstants.ARGS_FILE_COMMENT);
        
        activity.setValue(COMMENT_SUMMARY, StringUtils.abbreviate(comment, "…", 150));
    }
    
    
    @Override
    public boolean isMergeable(Activity activity1, Activity activity2)
    {
        // We don't want to merge for the moment as it would require to merge between different author
        // to recreate a conversation otherwise it would just be useless.
        return false;
    }
}
