/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.catalog;

import java.util.Map;

import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.ObservationConstants;
import org.ametys.web.repository.site.Site;

/**
 * Observer setting the mandatory configuration for catalog site
 * 
 * This will pre fill the configuration during site creation but will not enforce the value.
 * It is possible for the user to edit them in the configuration tool if he choose to
 */
public class InitializeCatalogConfigurationObserver extends AbstractLogEnabled implements Observer
{
    public boolean supports(Event event)
    {
        if (ObservationConstants.EVENT_SITE_ADDED.equals(event.getId()))
        {
            Site site = (Site) event.getArguments().get(ObservationConstants.ARGS_SITE);
            return CatalogSiteType.TYPE_ID.equals(site.getType());
        }
        return false;
    }

    public int getPriority()
    {
        // Configure the site before anything else
        return MAX_PRIORITY;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        Site site = (Site) event.getArguments().get(ObservationConstants.ARGS_SITE);
        // Hide restricted page
        site.setValue("display-restricted-pages", false);
        // Set public registration
        site.setValue("signup-type", "public");
        // Set comment moderation
        site.setValue("site-contents-comments-postvalidation", "post");
        site.saveChanges();
    }
}
