/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.cmis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;

import org.ametys.web.repository.site.SiteManager;

/**
 * Special authentication process for CMIS server, without project.
 */
public class AuthenticateAction extends org.ametys.core.authentication.AuthenticateAction
{
    private SiteManager _siteManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        _siteManager = (SiteManager) smanager.lookup(SiteManager.ROLE);
        super.service(smanager);
    }
    @Override
    protected List<String> _getContexts(Request request, Parameters parameters)
    {
     // We return all the populations linked to at least one site
        List<String> contexts = new ArrayList<>();

        // Retrieve the sites to build the contexts to search on
        Collection<String> siteNames = _siteManager.getSiteNames();

        for (String siteName : siteNames)
        {
            String siteContext = "/sites/" + siteName;
            contexts.add(siteContext);
            siteContext = "/sites-fo/" + siteName;
            contexts.add(siteContext);
        }
        
        return contexts;
    }
}
