/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.cmis;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.chemistry.opencmis.server.impl.CmisRepositoryContextListener;
import org.apache.chemistry.opencmis.server.impl.atompub.CmisAtomPubServlet;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.http.HttpEnvironment;

import org.ametys.core.servletwrapper.servlet.ServletWrapper;

/**
 * {@link ServiceableAction} that will wrap the {@link CmisAtomPubServlet}
 *
 */
public class CmisAction extends ServiceableAction implements ThreadSafe
{
    private CmisServiceFactory _workspaceCmisServiceFactory;
    private ServletWrapper _servletWrapper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        
        _workspaceCmisServiceFactory = (CmisServiceFactory) smanager.lookup(CmisServiceFactory.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        if (_servletWrapper == null)
        {
            ServletContext servletContext = (ServletContext) objectModel.get(HttpEnvironment.HTTP_SERVLET_CONTEXT);
            servletContext.setAttribute(CmisRepositoryContextListener.SERVICES_FACTORY, _workspaceCmisServiceFactory);
            
            CmisAtomPubServlet servlet = new CmisAtomPubServlet();
            _servletWrapper = new ServletWrapper(servlet);
            Map<String, String> servletParams = new HashMap<>();
            servletParams.put("cmisVersion", "1.1");
            servletParams.put("callContextHandler", "org.apache.chemistry.opencmis.server.shared.BasicAuthCallContextHandler");
            _servletWrapper.init("cmisatom11", servletContext, servletParams);
        }
        
        HttpServletRequest request = (HttpServletRequest) objectModel.get(HttpEnvironment.HTTP_REQUEST_OBJECT);
        CmisHttpServletRequest wsRequest = new CmisHttpServletRequest(request, source);
        HttpServletResponse response = (HttpServletResponse) objectModel.get(HttpEnvironment.HTTP_RESPONSE_OBJECT);
        
        _servletWrapper.service(wsRequest, response, objectModel, redirector);
        return EMPTY_MAP;
    }
}
