/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.data.type;

import org.ametys.runtime.model.type.ModelItemType;

/**
 * Extension point holding all {@link ModelItemType} classes for needing features.
 */
public class ModelItemTypeExtensionPoint extends org.ametys.web.data.type.ModelItemTypeExtensionPoint
{
    /** Avalon Role for project types */
    public static final String ROLE_PROJECT = ModelItemTypeExtensionPoint.class.getName() + ".Project";
    
    /** Avalon Role for task types */
    public static final String ROLE_TASK = ModelItemTypeExtensionPoint.class.getName() + ".Task";
    
    /** Avalon Role for task list types */
    public static final String ROLE_TASK_LIST = ModelItemTypeExtensionPoint.class.getName() + ".TaskList";
    
    /** Avalon Role for thread types */
    public static final String ROLE_THREAD = ModelItemTypeExtensionPoint.class.getName() + ".Thread";
}
