/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.dav;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.http.HttpEnvironment;
import org.apache.cocoon.environment.http.HttpResponse;

import org.ametys.core.user.CurrentUserProvider;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.explorer.resources.actions.ExplorerResourcesDAO;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.project.objects.Project;

/**
 * Action for WebDAV PUT method
 *
 */
public class WebdavMkcolAction extends AbstractAction implements Serviceable
{
    
    private AmetysObjectResolver _resolver;

    private ExplorerResourcesDAO _resourcesDAO;
    
    private CurrentUserProvider _currentUserProvider;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        _resolver = (AmetysObjectResolver) smanager.lookup(AmetysObjectResolver.ROLE);
        _resourcesDAO = (ExplorerResourcesDAO) smanager.lookup(ExplorerResourcesDAO.ROLE);
        _currentUserProvider = (CurrentUserProvider) smanager.lookup(CurrentUserProvider.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        HttpServletRequest request = (HttpServletRequest) objectModel.get(HttpEnvironment.HTTP_REQUEST_OBJECT);

        String path = parameters.getParameter("path");
        Project project = (Project) request.getAttribute("project"); 
        ModifiableResourceCollection parent = _resolver.resolveByPath(project.getPath() + "/ametys-internal:resources/");
        
        //list of possible errors, that will not be used because the only possible error is "lock", and they can not be locked
        List<String> errors = new ArrayList<>();
        
        for (String folder : path.split("/"))
        {
            if (folder.isEmpty())
            {
                continue;
            }
            if (!parent.hasChild(folder))
            {
                _resourcesDAO.addResourceCollection(parent, folder, false, errors);
            }
            if (!errors.isEmpty())
            {
                getLogger().error("User '" + _currentUserProvider.getUser() + "' try create a collection named '" + folder + "' in parent '" + parent.getId() + "' but it failed with message : " + errors.get(0));
                HttpResponse response = (HttpResponse) ObjectModelHelper.getResponse(objectModel);
                response.setStatus(423); //locked
                return EMPTY_MAP;
            }
            parent = parent.getChild(folder);
        }
        return EMPTY_MAP;
    }
}
