/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.documents;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.component.Component;

import org.ametys.cms.repository.comment.AbstractComment;
import org.ametys.plugins.workspaces.util.WorkspaceObjectJSONHelper;

/**
 * Helper to convert documents to JSON
 */
public class DocumentsJSONHelper extends WorkspaceObjectJSONHelper implements Component
{
    /** The Avalon role */
    public static final String ROLE = DocumentsJSONHelper.class.getName();
    

    /**
     * return a list of comments in JSON format
     * @param <T> type of the value to retrieve
     * @param comments the comments to translate as JSON
     * @param lang the current language
     * @param siteName The current site name
     * @return list of comments
     */
    public <T extends AbstractComment> List<Map<String, Object>> commentsToJson(List<T> comments, String lang, String siteName)
    {
        List<Map<String, Object>> json = new ArrayList<>();

        for (T comment : comments)
        {
            Map<String, Object> commentAsJSON = _commentToJson(comment, lang, siteName, null, true);
            // As we do not want file comments to be editable or deletable, remove rights
            commentAsJSON.put("canHandle", false);
            json.add(commentAsJSON);
        }

        return json;
    }
}
