/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.documents.generators;

import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.resources.generators.ResourcesExplorerGenerator;

/**
 * Generates a subtree of {@link ExplorerNode}. Change the path of project resources to be compatible with explorer node model
 */
public class ProjectResourcesExplorerGenerator extends ResourcesExplorerGenerator
{
    @Override
    protected String _getNodePath(String relPath)
    {
        return relPath.startsWith("/") 
                ? relPath.startsWith("/documents")
                        ?  relPath.substring("/documents".length()) 
                        :  relPath.substring(1)
                : relPath.startsWith("documents")
                        ?  relPath.substring("documents".length()) 
                        :  relPath;
    }
}
