/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.forum.filters;

import org.ametys.plugins.workspaces.forum.Thread;

/**
 * Filter to check if a thread has an accepted answer or not
 */
public class AcceptedFilter implements ThreadFilter
{
    private Boolean _accepted;
    
    /**
     * Filter to check if a thread has an accepted answer or not
     * @param accepted true to check thread with accepted answer, false to check threads without accepted answer
     */
    public AcceptedFilter(Boolean accepted) 
    {
        _accepted = accepted;
    }
    
    public boolean passFilter(Thread thread)
    {
        if (_accepted == null)
        {
            return true;
        }
        
        boolean hasAcceptedAnswer = thread.getAcceptedAnswer() != null;
        
        return _accepted == hasAcceptedAnswer;
    }

}
