/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.forum.filters;

import org.ametys.plugins.workspaces.forum.Thread;
import org.ametys.plugins.workspaces.forum.WorkspaceThreadUserPreferencesDAO;

/**
 * Filter to check if the current user has a notification for the given thread
 */
public class NotificationFilter implements ThreadFilter
{
    private Boolean _hasNotification;
    private WorkspaceThreadUserPreferencesDAO _workspaceThreadUserPrefDAO;
    
    /**
     * Filter to check if the current user has a notification for the given thread
     * @param hasNotification true to check if the current user has a notification for the given thread
     * @param workspaceThreadUserPrefDAO The workspace thread user preferences DAO
     */
    public NotificationFilter(Boolean hasNotification, WorkspaceThreadUserPreferencesDAO workspaceThreadUserPrefDAO) 
    {
        _hasNotification = hasNotification;
        _workspaceThreadUserPrefDAO = workspaceThreadUserPrefDAO;
    }
    
    public boolean passFilter(Thread thread)
    {
        if (_hasNotification == null)
        {
            return true;
        }
        return _hasNotification == _workspaceThreadUserPrefDAO.hasNotification(thread);
    }
}
