/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.members;

import java.io.IOException;
import java.util.List;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.xml.sax.SAXException;

import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.workspaces.WorkspacesConstants;
import org.ametys.runtime.model.View;

/**
 * Sax a list of related members with the current member content
 *
 */
public class RelatedMembersGenerator extends ServiceableGenerator
{
    private MemberHelper _memberHelper;
    private ContentTypesHelper _contentTypeHelper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _memberHelper = (MemberHelper) smanager.lookup(MemberHelper.ROLE);
        _contentTypeHelper = (ContentTypesHelper) manager.lookup(ContentTypesHelper.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException
    {
        contentHandler.startDocument();
        XMLUtils.startElement(contentHandler, "related-members");
        
        Request request = ObjectModelHelper.getRequest(objectModel);
        Content content = (Content) request.getAttribute(Content.class.getName());
        
        try
        {
            List<Content> relatedMembers = _memberHelper.getRelatedMembers(content, 6);
            for (Content relatedMember : relatedMembers)
            {
                View view = _contentTypeHelper.getView("abstract", new String[] {WorkspacesConstants.MEMBER_CONTENT_TYPE_ID}, new String[0]);
                relatedMember.toSAX(contentHandler, LocaleUtils.toLocale(content.getLanguage()), view, false);
            }
        }
        catch (Exception e)
        {
            getLogger().error("Failed to search related members with common skills and keywords", e);
        }
        
        XMLUtils.endElement(contentHandler, "related-members");
        contentHandler.endDocument();
    }
}
