/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.project;

import org.ametys.web.repository.site.DefaultSiteType;

/**
 * Project workspace site type.
 */
public class ProjectWorkspaceSiteType extends DefaultSiteType
{
    /** Id of the project workspace site type */
    public static final String TYPE_ID = "workspaces.project";

    /** data name for the excluded populations boolean */
    public static final String PROJECT_OVERRIDE_EXCLUDED_POPULATIONS_SITE_PARAM = "overrideExcludedPopulation";
    
    /** data name for the excluded populations of this project */
    public static final String PROJECT_EXCLUDED_POPULATIONS_PROJECT_SITE_PARAM = "workspacesExcludedPopulationProject";
    
    @Override
    public boolean isPrivateType()
    {
        return true;
    }
    
    @Override
    public boolean siteInitiallyRestricted()
    {
        return true;
    }
}
