/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.project.actions;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.objects.Project;

/**
 * This action exports the current project and its JCR path
 */
public class GetProjectAction extends ServiceableAction
{
    private ProjectManager _projectManager;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _projectManager = (ProjectManager) smanager.lookup(ProjectManager.ROLE);
    }
    
    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        String projectName = source;
        
        Request request = ObjectModelHelper.getRequest(objectModel);
        
        if (projectName == null)
        {
            projectName = request.getParameter("projectName");
        }
        
        if (projectName == null)
        {
            projectName = (String) request.getAttribute("projectName");
        }
        
        if (projectName == null)
        {
            throw new ResourceNotFoundException("Unable to get project name from environment");
        }

        Project project = _projectManager.getProject(projectName);
        
        // Save the project for future usage.
        request.setAttribute("project", project);
        
        Map<String, String> result = new HashMap<>();
        result.put("projectName", projectName);
        result.put("jcrProjectPath", project.getPath());
        
        return result;
    }
}
