/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.project.generators;

import java.io.IOException;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

import org.ametys.plugins.workspaces.tasks.taskexporter.TaskExporter;
import org.ametys.plugins.workspaces.tasks.taskexporter.TaskExporterExtensionPoint;

/**
 * Generator for the vuejs task export service
 */
public class ProjectsTasksGenerator extends ServiceableGenerator
{

    /** The task exporter */
    protected TaskExporterExtensionPoint _taskExporter;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _taskExporter = (TaskExporterExtensionPoint) serviceManager.lookup(TaskExporterExtensionPoint.ROLE);
    }
    
    public void generate() throws IOException, SAXException, ProcessingException
    {
        contentHandler.startDocument();
        XMLUtils.startElement(contentHandler, "tasks");

        _saxExportLinks();
        
        XMLUtils.endElement(contentHandler, "tasks");
        contentHandler.endDocument();
    }
    
    private void _saxExportLinks() throws SAXException
    {
        XMLUtils.startElement(contentHandler, "exportLinks");
        

        for (String extensionId : _taskExporter.getExtensionsIds())
        {
            TaskExporter link = _taskExporter.getExtension(extensionId);
            XMLUtils.startElement(contentHandler, "link");

            link.getListLabel().toSAX(contentHandler, "listLabel");
            link.getTitleLabel().toSAX(contentHandler, "titleLabel");
            link.getDescriptionLabel().toSAX(contentHandler, "descritptionLabel");
            XMLUtils.createElement(contentHandler, "icon", link.getIcon());
            XMLUtils.createElement(contentHandler, "url", link.getUrlCallPrefix());
            XMLUtils.createElement(contentHandler, "openingMode", link.getOpeningMode());
            
            XMLUtils.endElement(contentHandler, "link");
            
        }
        
        XMLUtils.endElement(contentHandler, "exportLinks");
    }
    
}
