/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.workspaces.project.generators;

import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.workspaces.activities.tasks.TaskClosedStatusChangedActivityType;
import org.ametys.plugins.workspaces.tasks.TasksWorkspaceModule;


/**
 * Generator for Task mail notification
 */
public class TaskMailNotifierGenerator extends AbstractMailNotifierGenerator
{
    @Override
    protected String _getModuleId()
    {
        return TasksWorkspaceModule.TASK_MODULE_ID;
    }
    
    @Override
    protected void saxAdditionalData(Activity activity) throws SAXException
    {
        super.saxAdditionalData(activity);
        
        if (activity.getActivityType() instanceof TaskClosedStatusChangedActivityType)
        {
            XMLUtils.createElement(contentHandler, "closed", activity.<String>getValue(TaskClosedStatusChangedActivityType.IS_CLOSED));
        }
    }
}
