/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.workspaces.search;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;

/**
 * Static implementation of a {@link SearchModule}
 */
public class StaticSearchModule implements SearchModule, Configurable, PluginAware
{
    /** The plugin name */
    protected String _pluginName;
    /** The feature name */
    protected String _featureName;
    
    private String _id;
    private I18nizableText _title;
    private String _searchUrl;
    private int _limit;
    private int _minLimit;
    private int _order;
    private String _refModuleId;
    
    public void setPluginInfo(String pluginName, String featureName, String id)
    {
        _pluginName = pluginName;
        _featureName = featureName;
        _id = id;
    }
    
    public void configure(Configuration configuration) throws ConfigurationException
    {
        _title = I18nizableText.parseI18nizableText(configuration.getChild("title"), "plugin." + _pluginName, "");
        
        Configuration urlConfiguration = configuration.getChild("searchUrl");
        String pluginUrl = urlConfiguration.getAttribute("plugin", _pluginName);
        _searchUrl = "_plugins/" + pluginUrl + "/" + urlConfiguration.getValue();
        
        Configuration limitConfiguration = configuration.getChild("limit");
        _limit = limitConfiguration.getValueAsInteger();
        
        Configuration allModuleLimitConfiguration = configuration.getChild("minLimit", true);
        _minLimit = allModuleLimitConfiguration.getValueAsInteger(_limit);
        
        Configuration orderConfiguration = configuration.getChild("order");
        _order = orderConfiguration.getValueAsInteger();
        
        _refModuleId = configuration.getChild("refModuleId").getValue(null);
        
    }
    
    public String getId()
    {
        return _id;
    }
    
    public I18nizableText getTitle()
    {
        return _title;
    }

    public String getSearchUrl()
    {
        return _searchUrl;
    }

    public int getLimit()
    {
        return _limit;
    }

    public int getMinLimit()
    {
        return _minLimit;
    }

    public int getOrder()
    {
        return _order;
    }
    
    public String getReferenceModuleId()
    {
        return _refModuleId;
    }
}
