/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.tasks.actions;

import java.util.List;

import org.apache.cocoon.environment.Request;

import org.ametys.plugins.workspaces.tasks.Task;

/**
 * Action providing data about a Task by it's id.
 */
public class GetTaskForICSAction extends AbstractGetTasksForExportAction
{

    @Override
    protected List<Task> getTasks(Request request)
    {
        String id = request.getParameter("id");
        Task task = _resolver.resolveById(id);
        
        return List.of(task);
    }

    @Override
    protected boolean _passFilter(Task task)
    {
        return task != null && (task.getDueDate() != null || task.getStartDate() != null);
    }
}
