/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.tasks.json;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

import org.ametys.plugins.workspaces.tasks.TasksList;
import org.ametys.plugins.workspaces.tasks.TasksListColorsComponent;
import org.ametys.plugins.workspaces.tasks.TasksListIconsComponent;
import org.ametys.plugins.workspaces.tasks.jcr.JCRTasksList;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

/**
 * Helper to convert tasks list to JSON
 */
public class TasksListJSONHelper extends AbstractLogEnabled implements Component, Serviceable
{
    /** The Avalon role */
    public static final String ROLE = TasksListJSONHelper.class.getName();
    
    /** The tasks list colors component */ 
    protected TasksListColorsComponent _tasksListColorsComponent;
    
    /** The tasks list icons component */
    protected TasksListIconsComponent _tasksListIconsComponent;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        _tasksListColorsComponent = (TasksListColorsComponent) manager.lookup(TasksListColorsComponent.ROLE);
        _tasksListIconsComponent = (TasksListIconsComponent) manager.lookup(TasksListIconsComponent.ROLE);
    }
    
    /**
     * Tasks list to json
     * @param tasksList the tasks list
     * @return the tasks list to json
     */
    public Map<String, Object> tasksListAsJson(TasksList tasksList)
    {
        Map<String, Object> json = new HashMap<>();
        json.put(JCRTasksList.ATTRIBUTE_ID, tasksList.getListId());
        json.put(JCRTasksList.ATTRIBUTE_LABEL, tasksList.getLabel());
        json.put(JCRTasksList.ATTRIBUTE_POSITION , tasksList.getPosition());
        
        String color = tasksList.getColor();
        json.put(JCRTasksList.ATTRIBUTE_COLOR_ID , StringUtils.isNotBlank(color) ? color : _tasksListColorsComponent.getDefaultKey());
        
        String icon = tasksList.getIcon();
        json.put(JCRTasksList.ATTRIBUTE_ICON_ID , StringUtils.isNotBlank(icon) ? icon : _tasksListIconsComponent.getDefaultKey());
        
        return json;
    }
}
