/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.archive;

import java.io.IOException;
import java.nio.file.Path;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.ametys.plugins.contentio.archive.DefaultPluginArchiver;
import org.ametys.plugins.contentio.archive.ImportReport;
import org.ametys.plugins.contentio.archive.Merger;
import org.ametys.plugins.contentio.archive.SystemViewHandler;
import org.ametys.plugins.contentio.archive.ZipEntryHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.archive.ProjectArchiverHelper;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.xml.sax.ContentHandler;

public class WorkspacePluginArchiver
extends DefaultPluginArchiver {
    private static final String __PROJECTS_NODE_NAME = "projects";
    protected AmetysObjectResolver _resolver;
    protected ProjectArchiverHelper _projectArchiverHelper;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._projectArchiverHelper = (ProjectArchiverHelper)((Object)manager.lookup(ProjectArchiverHelper.ROLE));
    }

    protected ContentHandler getSystemViewHandler(ContentHandler initialHandler) {
        return new SystemViewHandler(initialHandler, name -> __PROJECTS_NODE_NAME.equals(name), __ -> false);
    }

    public void export(String pluginName, Node pluginNode, ZipOutputStream zos, String prefix) throws IOException {
        super.export(pluginName, pluginNode, zos, prefix);
        try {
            if (pluginNode.hasNode(__PROJECTS_NODE_NAME)) {
                Node projectsNode = pluginNode.getNode(__PROJECTS_NODE_NAME);
                NodeIterator it = projectsNode.getNodes();
                while (it.hasNext()) {
                    Node projectNode = it.nextNode();
                    Project project = (Project)this._resolver.resolve(projectNode, false);
                    this._projectArchiverHelper.exportProject(project, zos, prefix + "/projects/" + project.getName() + "/");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to archive plugin " + pluginName, e);
        }
    }

    public ImportReport partialImport(String pluginName, Node allPluginsNode, Path zipPath, String zipPluginEntryPath, Merger merger) throws IOException {
        ImportReport report = super.partialImport(pluginName, allPluginsNode, zipPath, zipPluginEntryPath, merger);
        String baseImportProjectPath = zipPluginEntryPath + "/projects";
        if (ZipEntryHelper.zipEntryFolderExists((Path)zipPath, (String)baseImportProjectPath)) {
            try {
                Node pluginNode = allPluginsNode.getNode(pluginName);
                report.addFrom(this._projectArchiverHelper.importProjects(pluginNode, zipPath, baseImportProjectPath, merger));
            }
            catch (RepositoryException e) {
                throw new IOException("Could not get plugin node for " + pluginName, e);
            }
        } else {
            this.getLogger().info("No project node to import. The path '{}!{}' does not exist", (Object)zipPath, (Object)baseImportProjectPath);
        }
        return report;
    }
}

