/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.calendars;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class CalendarColorsComponent
implements Component,
Configurable {
    public static final String ROLE = CalendarColorsComponent.class.getName();
    private Map<String, CalendarColor> _colors;
    private Map<String, CalendarColor> _allColors;

    public void configure(Configuration configuration) throws ConfigurationException {
        CalendarColor color;
        String fgColor;
        String bgColor;
        String label;
        String id;
        LinkedHashMap<String, CalendarColor> allColors = new LinkedHashMap<String, CalendarColor>();
        LinkedHashMap<String, CalendarColor> calendarColors = new LinkedHashMap<String, CalendarColor>();
        for (Configuration colorConfiguration : configuration.getChildren("resourceColor")) {
            id = colorConfiguration.getAttribute("id");
            label = colorConfiguration.getChild("label").getValue();
            bgColor = colorConfiguration.getChild("bg").getValue();
            fgColor = colorConfiguration.getChild("fg").getValue();
            color = new CalendarColor(this, id, label, bgColor, fgColor);
            allColors.put(id, color);
        }
        for (Configuration colorConfiguration : configuration.getChildren("color")) {
            id = colorConfiguration.getAttribute("id");
            label = colorConfiguration.getChild("label").getValue();
            bgColor = colorConfiguration.getChild("bg").getValue();
            fgColor = colorConfiguration.getChild("fg").getValue();
            color = new CalendarColor(this, id, label, bgColor, fgColor);
            calendarColors.put(id, color);
            allColors.put(id, color);
        }
        this._colors = calendarColors;
        this._allColors = allColors;
    }

    public Map<String, CalendarColor> getColors() {
        return this._colors;
    }

    public Map<String, CalendarColor> getAllColors() {
        return this._allColors;
    }

    public CalendarColor getColor(String id) {
        return this._allColors.get(id);
    }

    public class CalendarColor {
        String _bgColor;
        String _fgColor;
        String _label;
        String _id;

        public CalendarColor(CalendarColorsComponent this$0, String id, String label, String bgColor, String fgCOlor) {
            this._id = id;
            this._label = label;
            this._bgColor = bgColor;
            this._fgColor = fgCOlor;
        }

        public String getId() {
            return this._id;
        }

        public String getLabel() {
            return this._label;
        }

        public String getColor() {
            return this._bgColor;
        }

        public String getTextColor() {
            return this._fgColor;
        }
    }
}

