/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.calendars;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.ametys.core.observation.Event;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.explorer.ModifiableExplorerNode;
import org.ametys.plugins.explorer.resources.jcr.JCRResourcesCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.calendars.AbstractCalendarDAO;
import org.ametys.plugins.workspaces.calendars.Calendar;
import org.ametys.plugins.workspaces.calendars.CalendarColorsComponent;
import org.ametys.plugins.workspaces.calendars.CalendarWorkspaceModule;
import org.ametys.plugins.workspaces.calendars.WorkflowAwareCalendar;
import org.ametys.plugins.workspaces.calendars.events.CalendarEvent;
import org.ametys.plugins.workspaces.calendars.events.CalendarEventJSONHelper;
import org.ametys.plugins.workspaces.calendars.jcr.JCRCalendar;
import org.ametys.plugins.workspaces.calendars.task.TaskCalendar;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.tasks.TasksWorkspaceModule;
import org.ametys.plugins.workspaces.tasks.WorkspaceTaskDAO;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;

public class CalendarDAO
extends AbstractCalendarDAO {
    public static final String ROLE = CalendarDAO.class.getName();
    protected CalendarEventJSONHelper _calendarEventJSONHelper;
    protected WorkspaceTaskDAO _taskDAO;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._calendarEventJSONHelper = (CalendarEventJSONHelper)((Object)manager.lookup(CalendarEventJSONHelper.ROLE));
        this._taskDAO = (WorkspaceTaskDAO)((Object)manager.lookup(WorkspaceTaskDAO.ROLE));
    }

    public Map<String, Object> getCalendarData(Calendar calendar, boolean recursive, boolean includeEvents, boolean useICSFormat) {
        TaskCalendar cal;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", calendar.getId());
        result.put("title", Text.unescapeIllegalJcrChars((String)calendar.getName()));
        result.put("description", calendar.getDescription());
        result.put("templateDesc", calendar.getTemplateDescription());
        result.put("color", calendar.getColor());
        result.put("visibility", calendar.getVisibility().name().toLowerCase());
        result.put("public", calendar.getVisibility() == Calendar.CalendarVisibility.PUBLIC);
        if (calendar instanceof WorkflowAwareCalendar) {
            WorkflowAwareCalendar calendarWA = (WorkflowAwareCalendar)calendar;
            result.put("workflowName", calendarWA.getWorkflowName());
        }
        result.put("isTaskCalendar", calendar instanceof TaskCalendar);
        result.put("isTaskCalendarDisabled", calendar instanceof TaskCalendar && (cal = (TaskCalendar)calendar).isDisabled());
        if (recursive) {
            LinkedList<Map<String, Object>> calendarList = new LinkedList<Map<String, Object>>();
            result.put("calendars", calendarList);
            for (Calendar child : calendar.getChildCalendars()) {
                calendarList.add(this.getCalendarData(child, recursive, includeEvents, useICSFormat));
            }
        }
        if (includeEvents) {
            LinkedList<Map<String, Object>> eventList = new LinkedList<Map<String, Object>>();
            result.put("events", eventList);
            for (CalendarEvent event : calendar.getAllEvents()) {
                eventList.add(this._calendarEventJSONHelper.eventAsJson(event, false, useICSFormat));
            }
        }
        result.put("rights", this._extractCalendarRightData(calendar));
        result.put("token", this.getCalendarIcsToken(calendar, true));
        return result;
    }

    public Map<String, Object> getCalendarProperties(Calendar calendar) {
        return this.getCalendarData(calendar, false, false, false);
    }

    @Callable(rights={""})
    public Map<String, Object> addCalendar(String inputName, String color, boolean isPublic) {
        String rootId = this._getCalendarRoot(true).getId();
        return this.addCalendar(rootId, inputName, "", "", color, isPublic ? Calendar.CalendarVisibility.PUBLIC.name() : Calendar.CalendarVisibility.PRIVATE.name(), "calendar-default", false);
    }

    public Map<String, Object> addCalendar(String id, String inputName, String description, String templateDesc, String color, String visibility, String workflowName, Boolean renameIfExists) {
        return this.addCalendar((ModifiableTraversableAmetysObject)this._resolver.resolveById(id), inputName, description, templateDesc, color, visibility, workflowName, renameIfExists, true, true);
    }

    public Map<String, Object> addCalendar(ModifiableTraversableAmetysObject parent, String inputName, String description, String templateDesc, String color, String visibility, String workflowName, Boolean renameIfExists, Boolean checkRights, boolean notify) {
        String originalName = Text.escapeIllegalJcrChars((String)inputName);
        if (checkRights.booleanValue()) {
            this._checkUserRights((AmetysObject)parent, "Plugins_Workspaces_Calendar_Add");
        }
        if (BooleanUtils.isNotTrue((Boolean)renameIfExists) && parent.hasChild(originalName)) {
            this.getLogger().warn("Cannot create the calendar with name '" + originalName + "', an object with same name already exists.");
            return Map.of("message", "already-exist");
        }
        if (!this._explorerResourcesDAO.checkLock((AmetysObject)parent)) {
            this.getLogger().warn("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' try to modify the object '" + parent.getName() + "' but it is locked by another user");
            return Map.of("message", "locked");
        }
        int index = 2;
        Object name = originalName;
        while (parent.hasChild((String)name)) {
            name = originalName + " (" + index + ")";
            ++index;
        }
        JCRCalendar calendar = (JCRCalendar)parent.createChild((String)name, "ametys:calendar");
        calendar.setWorkflowName(workflowName);
        calendar.setDescription(description);
        calendar.setTemplateDescription(templateDesc);
        calendar.setColor(color);
        calendar.setVisibility(StringUtils.isNotEmpty((CharSequence)visibility) ? Calendar.CalendarVisibility.valueOf(visibility.toUpperCase()) : Calendar.CalendarVisibility.PRIVATE);
        parent.saveChanges();
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("object.id", calendar.getId());
        eventParams.put("object.parent", parent.getId());
        eventParams.put("object.name", name);
        eventParams.put("object.path", calendar.getPath());
        if (notify) {
            this._observationManager.notify(new Event("calendar.created", this._currentUserProvider.getUser(), eventParams));
        }
        return this.getCalendarProperties(calendar);
    }

    @Callable(rights={""})
    public Map<String, Object> editCalendar(String id, String inputName, String templateDesc, String color, boolean isPublic) {
        Calendar.CalendarVisibility visibility;
        Calendar.CalendarVisibility calendarVisibility = visibility = isPublic ? Calendar.CalendarVisibility.PUBLIC : Calendar.CalendarVisibility.PRIVATE;
        assert (id != null);
        String rename = Text.escapeIllegalJcrChars((String)inputName);
        JCRCalendar calendar = (JCRCalendar)this._resolver.resolveById(id);
        this._checkUserRights((AmetysObject)calendar, "Plugins_Workspaces_Calendar_Edit");
        Object name = calendar.getName();
        ModifiableTraversableAmetysObject parent = (ModifiableTraversableAmetysObject)calendar.getParent();
        if (!StringUtils.equals((CharSequence)rename, (CharSequence)name) && parent.hasChild(rename)) {
            this.getLogger().warn("Cannot edit the calendar with the new name '" + inputName + "', an object with same name already exists.");
            return Map.of("message", "already-exist");
        }
        if (!this._explorerResourcesDAO.checkLock((AmetysObject)calendar)) {
            this.getLogger().warn("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' try to modify calendar '" + calendar.getName() + "' but it is locked by another user");
            return Map.of("message", "locked");
        }
        if (!StringUtils.equals((CharSequence)name, (CharSequence)rename)) {
            int index = 2;
            name = Text.escapeIllegalJcrChars((String)rename);
            while (parent.hasChild((String)name)) {
                name = rename + " (" + index + ")";
                ++index;
            }
            calendar.rename((String)name);
        }
        calendar.setTemplateDescription(templateDesc);
        calendar.setColor(color);
        calendar.setVisibility(visibility);
        parent.saveChanges();
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("object.id", calendar.getId());
        eventParams.put("object.parent", parent.getId());
        eventParams.put("object.name", name);
        eventParams.put("object.path", calendar.getPath());
        this._observationManager.notify(new Event("calendar.updated", this._currentUserProvider.getUser(), eventParams));
        return this.getCalendarProperties(calendar);
    }

    @Callable(rights={""})
    public Map<String, Object> editTaskCalendar(String inputName, String color, boolean isPublic, boolean disabled) throws IllegalAccessException {
        Project project = this._workspaceHelper.getProjectFromRequest();
        TaskCalendar taskCalendar = this.getTaskCalendar(project, false);
        this._checkUserRights((AmetysObject)this._getCalendarRoot(project, false), "Plugins_Workspaces_Calendar_Edit");
        if (taskCalendar != null) {
            taskCalendar.rename(inputName);
            taskCalendar.setColor(color);
            taskCalendar.setVisibility(isPublic ? Calendar.CalendarVisibility.PUBLIC : Calendar.CalendarVisibility.PRIVATE);
            taskCalendar.disable(disabled);
        }
        return this.getCalendarProperties(taskCalendar);
    }

    @Callable(rights={""})
    public Map<String, Object> deleteCalendar(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        assert (id != null);
        JCRCalendar calendar = (JCRCalendar)this._resolver.resolveById(id);
        this._checkUserRights((AmetysObject)calendar, "Plugins_Workspaces_Calendar_Delete");
        if (!this._explorerResourcesDAO.checkLock((AmetysObject)calendar)) {
            this.getLogger().warn("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' try to delete calendar'" + calendar.getName() + "' but it is locked by another user");
            result.put("message", "locked");
            return result;
        }
        ModifiableExplorerNode parent = (ModifiableExplorerNode)calendar.getParent();
        String parentId = parent.getId();
        String name = calendar.getName();
        String path = calendar.getPath();
        calendar.remove();
        parent.saveChanges();
        HashMap<String, String> eventParams = new HashMap<String, String>();
        eventParams.put("object.id", id);
        eventParams.put("object.parent", parentId);
        eventParams.put("object.name", name);
        eventParams.put("object.path", path);
        this._observationManager.notify(new Event("calendar.deleted", this._currentUserProvider.getUser(), eventParams));
        result.put("id", id);
        result.put("parentId", parentId);
        return result;
    }

    public String getCalendarIcsToken(Calendar calendar, boolean createIfNotExisting) {
        String token = calendar.getIcsUrlToken();
        if (createIfNotExisting && token == null && calendar instanceof JCRCalendar) {
            token = UUID.randomUUID().toString();
            ((JCRCalendar)calendar).setIcsUrlToken(token);
            ((JCRCalendar)calendar).saveChanges();
        }
        return token;
    }

    public Calendar getCalendarFromIcsToken(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return null;
        }
        StringExpression expr = new StringExpression("ics-token", Expression.Operator.EQ, token);
        String calendarsQuery = QueryHelper.getXPathQuery(null, (String)"ametys:calendar", (Expression)expr);
        AmetysObjectIterable calendars = this._resolver.query(calendarsQuery);
        AmetysObjectIterator calendarsIterator = calendars.iterator();
        if (calendarsIterator.getSize() > 0L) {
            return (Calendar)calendarsIterator.next();
        }
        return this._projectManager.getProjects().stream().map(p -> this.getTaskCalendar((Project)((Object)p), true)).filter(Objects::nonNull).filter(c -> c.getIcsUrlToken().equals(token)).findFirst().orElse(null);
    }

    protected Map<String, Object> _extractCalendarRightData(Calendar calendar) {
        HashMap<String, Object> rightsData = new HashMap<String, Object>();
        UserIdentity user = this._currentUserProvider.getUser();
        boolean isTaskCalendar = calendar instanceof TaskCalendar;
        rightsData.put("add-event", !isTaskCalendar && this._rightManager.hasRight(user, "Plugins_Workspaces_Event_Add", (Object)calendar) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("edit", !isTaskCalendar && this._rightManager.hasRight(user, "Plugins_Workspaces_Calendar_Edit", (Object)calendar) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("delete", !isTaskCalendar && this._rightManager.hasRight(user, "Plugins_Workspaces_Calendar_Delete", (Object)calendar) == RightManager.RightResult.RIGHT_ALLOW);
        return rightsData;
    }

    @Callable(rights={""})
    public List<Map<String, Object>> getCalendars() {
        Project project = this._workspaceHelper.getProjectFromRequest();
        this._checkReadAccess(project, CalendarWorkspaceModule.CALENDAR_MODULE_ID);
        ArrayList<Map<String, Object>> calendarsData = new ArrayList<Map<String, Object>>();
        CalendarWorkspaceModule calendarModule = (CalendarWorkspaceModule)this._workspaceModuleEP.getModule(CalendarWorkspaceModule.CALENDAR_MODULE_ID);
        for (Calendar calendar : calendarModule.getCalendars(project, true)) {
            if (!calendarModule.canView(calendar)) continue;
            calendarsData.add(this.getCalendarProperties(calendar));
        }
        return calendarsData;
    }

    @Callable(rights={"*"})
    public Map<String, CalendarColorsComponent.CalendarColor> getColors() {
        return this._calendarColors.getColors();
    }

    @Callable(rights={"*"})
    public Map<String, Object> getUserRights() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        ModifiableTraversableAmetysObject calendarRoot = this._getCalendarRoot(false);
        UserIdentity user = this._currentUserProvider.getUser();
        results.put("canCreateCalendar", calendarRoot != null && this._rightManager.hasRight(user, "Plugins_Workspaces_Calendar_Add", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canEditCalendar", calendarRoot != null && this._rightManager.hasRight(user, "Plugins_Workspaces_Calendar_Edit", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canRemoveCalendar", calendarRoot != null && this._rightManager.hasRight(user, "Plugins_Workspaces_Calendar_Delete", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canCreateEvent", calendarRoot != null && this._rightManager.hasRight(user, "Plugins_Workspaces_Event_Add", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canEditEvent", calendarRoot != null && this._rightManager.hasRight(user, "Plugins_Workspaces_Event_Edit", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canRemoveAnyEvent", calendarRoot != null && this._rightManager.hasRight(user, "Plugins_Workspaces_Event_Delete", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canRemoveSelfEvent", calendarRoot != null && this._rightManager.hasRight(user, "Plugins_Workspaces_Owned_Event_Delete", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canHandleResource", calendarRoot != null && this._rightManager.hasRight(user, "Plugins_Workspaces_Handle_Resource", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canBookResource", calendarRoot != null && this._rightManager.hasRight(user, "Plugins_Workspaces_Book_Resource", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("sharePrivateCalendar", calendarRoot != null && this._rightManager.hasRight(user, "Plugins_Workspaces_Event_Edit", (Object)calendarRoot) == RightManager.RightResult.RIGHT_ALLOW);
        return results;
    }

    protected ModifiableTraversableAmetysObject _getCalendarRoot(boolean createIfNotExist) {
        return this._getCalendarRoot(this._workspaceHelper.getProjectFromRequest(), createIfNotExist);
    }

    protected ModifiableTraversableAmetysObject _getCalendarRoot(Project project, boolean createIfNotExist) {
        CalendarWorkspaceModule calendarModule = (CalendarWorkspaceModule)this._workspaceModuleEP.getModule(CalendarWorkspaceModule.CALENDAR_MODULE_ID);
        return calendarModule.getCalendarsRoot(project, createIfNotExist);
    }

    @Callable(rights={""})
    public Map<String, Object> getResourceCalendar() {
        Project project = this._workspaceHelper.getProjectFromRequest();
        this._checkReadAccess(project, CalendarWorkspaceModule.CALENDAR_MODULE_ID);
        CalendarWorkspaceModule calendarModule = (CalendarWorkspaceModule)this._workspaceModuleEP.getModule(CalendarWorkspaceModule.CALENDAR_MODULE_ID);
        Calendar calendar = calendarModule.getResourceCalendar(project);
        return this.getCalendarProperties(calendar);
    }

    public TaskCalendar getTaskCalendar(Project project, boolean onlyIfEnabled) {
        if (this._projectManager.isModuleActivated(project, TasksWorkspaceModule.TASK_MODULE_ID)) {
            JCRResourcesCollection root = (JCRResourcesCollection)this._getCalendarRoot(project, false);
            TaskCalendar calendar = new TaskCalendar(project, root, this._taskDAO);
            return !onlyIfEnabled || !calendar.isDisabled() ? calendar : null;
        }
        return null;
    }

    public boolean hasTaskCalendarReadAccess(Project project) {
        TasksWorkspaceModule taskModule = (TasksWorkspaceModule)this._workspaceModuleEP.getModule(TasksWorkspaceModule.TASK_MODULE_ID);
        DefaultTraversableAmetysObject tasksRoot = taskModule.getTasksRoot(project, true);
        return this._rightManager.currentUserHasReadAccess((Object)tasksRoot);
    }
}

