/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.categories;

import java.util.HashMap;
import java.util.Map;
import org.ametys.cms.color.AbstractColorsComponent;
import org.ametys.cms.tag.ColorableTag;
import org.ametys.cms.tag.Tag;
import org.ametys.runtime.i18n.I18nizableText;

public class Category
implements ColorableTag {
    private String _id;
    private String _name;
    private I18nizableText _title;
    private I18nizableText _description;
    private String _color;
    private AbstractColorsComponent _colorsComponent;
    private Map<String, Category> _tags;
    private Category _parent;

    public Category(String id) {
        this._id = id;
    }

    public Category(String id, String name, Category parent, I18nizableText title, I18nizableText description) {
        this._id = id;
        this._name = name;
        this._parent = parent;
        this._title = title;
        this._description = description;
    }

    public Category(String id, String name, String color, AbstractColorsComponent colorsComponent, Category parent, I18nizableText title, I18nizableText description) {
        this(id, name, parent, title, description);
        this._color = color;
        this._colorsComponent = colorsComponent;
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public I18nizableText getTitle() {
        return this._title;
    }

    public I18nizableText getDescription() {
        return this._description;
    }

    public String getColor(boolean withDefaultValue) {
        return this._color;
    }

    public AbstractColorsComponent getColorComponent() {
        return this._colorsComponent;
    }

    public String getParentName() {
        return this._parent != null ? this._parent.getName() : null;
    }

    public Category getParent() {
        return this._parent;
    }

    public void addTag(Tag tag) {
        if (this._tags == null) {
            this._tags = new HashMap<String, Category>();
        }
        this._tags.put(tag.getId(), (Category)tag);
    }

    public Map<String, Category> getTags() {
        if (this._tags == null) {
            this._tags = new HashMap<String, Category>();
        }
        return this._tags;
    }

    public Category getTag(String tagId) {
        if (this._tags == null) {
            this._tags = new HashMap<String, Category>();
        }
        return this._tags.get(tagId);
    }

    public boolean hasTag(String tagId) {
        if (this._tags == null) {
            this._tags = new HashMap<String, Category>();
        }
        return this._tags.containsKey(tagId);
    }

    public void setTags(Map<String, ? extends Tag> tags) {
        this._tags = tags;
    }
}

