/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.comments;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ametys.cms.repository.comment.RichTextComment;
import org.ametys.cms.repository.mentions.AbstractNotifyMentionsObserver;
import org.ametys.core.observation.Event;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.workspaces.comments.AbstractNotifyWorkspacesCommentMentionsObserver;
import org.ametys.plugins.workspaces.forum.ForumWorkspaceModule;
import org.ametys.plugins.workspaces.forum.Thread;
import org.ametys.plugins.workspaces.forum.json.ThreadJSONHelper;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.WebHelper;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class NotifyThreadCommentMentionsObserver
extends AbstractNotifyWorkspacesCommentMentionsObserver<Thread> {
    protected ForumWorkspaceModule _forumModule;
    protected ThreadJSONHelper _threadJSONHelper;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        WorkspaceModuleExtensionPoint moduleManagerEP = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._forumModule = (ForumWorkspaceModule)moduleManagerEP.getModule(ForumWorkspaceModule.FORUM_MODULE_ID);
        this._threadJSONHelper = (ThreadJSONHelper)((Object)manager.lookup(ThreadJSONHelper.ROLE));
    }

    @Override
    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public boolean supports(Event event) {
        return event.getId().equals("forumthread.commented");
    }

    protected String _getAmetysObjectTitle(Thread thread) {
        return thread.getTitle();
    }

    protected I18nizableText _getMailMessage(AbstractNotifyMentionsObserver.MentionableObject mentionableObject) {
        Thread thread = (Thread)mentionableObject.ametysObject();
        Project project = this._projectManager.getParentProject((AmetysObject)thread);
        User author = mentionableObject.author();
        List<String> i18nParams = List.of(author.getFullName(), this._getAmetysObjectTitle(thread), project.getTitle());
        return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_THREAD_COMMENT_MENTION_MAIL_MESSAGE", i18nParams);
    }

    private String _getContent(RichTextComment comment, Project project) throws Exception {
        Request request = ContextHelper.getRequest((Context)this._context);
        String siteName = WebHelper.getSiteName((Request)request);
        if (siteName == null) {
            request.setAttribute("site", (Object)project.getSite().getName());
        }
        return this._threadJSONHelper.richTextToRendering(comment.getRichTextContent());
    }

    protected String _transformSyntaxTextToReadableTextWithColors(String content, UserIdentity recipient) {
        return this._mentionUtils.transformRichTextToReadableText(content, recipient);
    }

    protected AbstractNotifyMentionsObserver.MentionableObject _getMentionableObjectFromArguments(Map<String, Object> arguments) throws Exception {
        Thread thread = (Thread)this._getAmetysObjectFromArguments(arguments);
        RichTextComment comment = (RichTextComment)arguments.get("forumthreadcomment");
        comment = (RichTextComment)thread.getComment(comment.getId());
        Project project = this._projectManager.getParentProject((AmetysObject)thread);
        String url = this._getAbsoluteUrl(thread, project);
        String content = this._getContent(comment, project);
        return new AbstractNotifyMentionsObserver.MentionableObject(this._userManager.getUser(comment.getAuthor()), content, (Collection)this._mentionUtils.extractMentionedUsersFromRichText(content), comment.getCreationDate(), (AmetysObject)thread, new AbstractNotifyMentionsObserver.LinkToAmetysObject(url, new I18nizableText("plugin.workspaces", "PROJECT_MAIL_NOTIFICATION_BODY_FORUMTHREAD_BUTTON_TEXT")), this._getLanguage(project));
    }

    protected I18nizableText _getMailMessageType() {
        return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_THREAD_MENTION_MAIL_THREAD_COMMENT_TITLE");
    }

    @Override
    protected String _getModuleId() {
        return ForumWorkspaceModule.FORUM_MODULE_ID;
    }

    @Override
    protected String getUrl(Thread thread, Project project) {
        return this._forumModule.getThreadUri(project, thread.getId());
    }
}

