/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents;

import java.util.HashSet;
import org.ametys.core.authentication.token.AuthenticationTokenManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.workspaces.documents.ProjectResourceURIResolver;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class WebdavProjectResourceURIResolver
extends ProjectResourceURIResolver {
    protected AuthenticationTokenManager _authenticationTokenManager;
    protected CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._authenticationTokenManager = (AuthenticationTokenManager)manager.lookup(AuthenticationTokenManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    @Override
    public String getType() {
        return "webdav-project-resource";
    }

    @Override
    protected String getUriPrefix(AmetysObject object, boolean download, boolean absolute, boolean internal) {
        Project project = null;
        String projectName = null;
        String siteName = null;
        UserIdentity user = this._currentUserProvider.getUser();
        long duration = 43200L;
        boolean autoRenew = true;
        HashSet<String> contexts = new HashSet<String>();
        String path = this.getPath(object);
        path = StringUtils.removeStart((String)path, (String)"/");
        contexts.add(path);
        if (object instanceof Resource) {
            String parentPath = this.getPath(object.getParent());
            parentPath = StringUtils.removeStart((String)parentPath, (String)"/").concat("/");
            contexts.add(parentPath);
        }
        String type = "Workspaces-Webdav";
        String comment = "Token created to modify content : '" + object.getId() + "'";
        String token = this._authenticationTokenManager.generateToken(user, duration, autoRenew, null, contexts, type, comment);
        project = this._getProject(object);
        projectName = project.getName();
        siteName = project.getSite().getName();
        if (internal) {
            return "cocoon://_workspaces/dav/" + projectName + "/" + token;
        }
        if (absolute) {
            return this._webPrefixHandler.getAbsoluteUriPrefix(siteName) + "/_workspaces/dav/" + projectName + "/" + token;
        }
        return this._webPrefixHandler.getUriPrefix(siteName) + "/_workspaces/dav/" + projectName + "/" + token;
    }

    protected String getPath(AmetysObject resource) {
        String path = null;
        if (resource instanceof Resource) {
            path = this.getResourcePath((Resource)resource);
        } else if (resource instanceof ResourceCollection) {
            path = ((ResourceCollection)resource).getExplorerPath();
        } else {
            this.getLogger().error("Trying to access to something that is not a Resource or a ResourceCollection : " + resource.getId());
        }
        return path;
    }

    protected String getRealPrefix(Resource resource, String prefix) {
        return null;
    }
}

