/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents.datapolicy;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.ametys.cms.repository.comment.Comment;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.workspaces.datapolicy.AbstractCommentAndReactionDataPolicy;
import org.ametys.plugins.workspaces.documents.jcr.File;
import org.apache.commons.lang3.tuple.Pair;

public class DocumentCommentAndReactionDataPolicy
extends AbstractCommentAndReactionDataPolicy {
    @Override
    protected String getLogCategory() {
        return "document";
    }

    @Override
    protected String getObjectPrimaryType() {
        return "ametys:file";
    }

    @Override
    protected boolean handleComment(Node commentNode) {
        try {
            Pair<Node, String> holderAndCommentId = this.getObjectNodeAndCommentId(commentNode);
            if (holderAndCommentId != null) {
                File file = (File)this._resolver.resolve((Node)holderAndCommentId.getLeft(), false);
                Comment comment = file.getComment((String)holderAndCommentId.getRight());
                comment.setAuthor(UserPopulationDAO.UNKNOWN_USER_IDENTITY);
                comment.setAuthorEmail(null);
                comment.setAuthorName(null);
                file.saveChanges();
                return true;
            }
        }
        catch (RepositoryException | AmetysRepositoryException e) {
            this.getLogger().error("Failed to retrieve file and comment from comment node '{}'", (Object)commentNode, (Object)e);
        }
        return false;
    }
}

