/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.files;

import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.documents.jcr.File;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;

public class CheckWorkspacesFileDownloadPublicTokenReadAccessAction
extends ServiceableAction {
    protected AmetysObjectResolver _resolver;
    private Repository _repository;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._repository = (Repository)smanager.lookup("javax.jcr.Repository");
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        String tokenId = parameters.getParameter("tokenId", "");
        File.PublicLinkToken token = this._getTokenByID(tokenId);
        if (token == null) {
            throw new AccessDeniedException("CheckPublicTokenReadAccessAction: a valid token must be provided.");
        }
        File file = (File)this._resolver.resolveById(token.fileId());
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("filePath", file.getPath());
        return result;
    }

    private File.PublicLinkToken _getTokenByID(String tokenId) {
        Session session = null;
        try {
            session = this._repository.login();
            StringExpression tokenExpression = new StringExpression("tokenId", Expression.Operator.EQ, tokenId);
            String jcrQuery = QueryHelper.getXPathQuery(null, (String)"ametys:compositeMetadata", (Expression)tokenExpression);
            Query query = session.getWorkspace().getQueryManager().createQuery(jcrQuery, "xpath");
            NodeIterator nodes = query.execute().getNodes();
            while (nodes.hasNext()) {
                Node node = (Node)nodes.next();
                String fileId = node.getProperty("ametys:fileId").getString();
                ZonedDateTime date = DateUtils.asZonedDateTime((Calendar)node.getProperty("ametys:creationDate").getDate());
                Node tokensNode = node.getParent();
                Node fileNode = tokensNode.getParent();
                String fileNodeId = "file://" + fileNode.getIdentifier();
                if (!fileNodeId.equals(fileId)) continue;
                return new File.PublicLinkToken(tokenId, date, fileId);
            }
            return null;
        }
        catch (RepositoryException ex) {
            if (session != null) {
                session.logout();
            }
            throw new AmetysRepositoryException("An error occurred executing the JCR query to get token " + tokenId, (Throwable)ex);
        }
    }
}

