/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.forum.datapolicy;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.ametys.cms.repository.comment.RichTextComment;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.workspaces.datapolicy.AbstractCommentAndReactionDataPolicy;
import org.ametys.plugins.workspaces.forum.jcr.JCRThread;
import org.apache.commons.lang3.tuple.Pair;

public class ThreadCommentAndReactionDataPolicy
extends AbstractCommentAndReactionDataPolicy {
    @Override
    protected String getLogCategory() {
        return "thread";
    }

    @Override
    protected boolean handleComment(Node commentNode) {
        try {
            Pair<Node, String> holderAndCommentId = this.getObjectNodeAndCommentId(commentNode);
            if (holderAndCommentId != null) {
                JCRThread thread = (JCRThread)this._resolver.resolve((Node)holderAndCommentId.getLeft(), false);
                RichTextComment comment = thread.getComment((String)holderAndCommentId.getRight());
                comment.setAuthor(UserPopulationDAO.UNKNOWN_USER_IDENTITY);
                comment.setAuthorEmail(null);
                comment.setAuthorName(null);
                thread.saveChanges();
                return true;
            }
        }
        catch (RepositoryException | AmetysRepositoryException e) {
            this.getLogger().error("Failed to retrieve thread and comment from comment node '{}'", (Object)commentNode, (Object)e);
        }
        return false;
    }

    @Override
    protected String getObjectPrimaryType() {
        return "ametys:forum-thread";
    }
}

