/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.indexing.solr;

import java.io.IOException;
import org.ametys.cms.content.indexing.solr.SolrIndexer;
import org.ametys.cms.content.indexing.solr.SolrResourceIndexer;
import org.ametys.cms.search.solr.SolrClientProvider;
import org.ametys.core.schedule.progression.ProgressionTrackerFactory;
import org.ametys.core.schedule.progression.SimpleProgressionTracker;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.workspaces.indexing.solr.SolrWorkspacesConstants;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;

public class SolrProjectResourceIndexer
extends AbstractLogEnabled
implements Component,
Serviceable,
SolrWorkspacesConstants {
    public static final String ROLE = SolrProjectResourceIndexer.class.getName();
    protected SolrClientProvider _solrClientProvider;
    protected SolrResourceIndexer _solrResourceIndexer;
    protected SolrIndexer _solrIndexer;

    public void service(ServiceManager manager) throws ServiceException {
        this._solrClientProvider = (SolrClientProvider)manager.lookup(SolrClientProvider.ROLE);
        this._solrResourceIndexer = (SolrResourceIndexer)manager.lookup(SolrResourceIndexer.ROLE);
        this._solrIndexer = (SolrIndexer)manager.lookup(SolrIndexer.ROLE);
    }

    public void indexProjectResources(ResourceCollection collection, Project project, String workspaceName) throws Exception {
        SolrClient solrClient = this._solrClientProvider.getUpdateClient(workspaceName, true);
        this.indexProjectResources(collection, project, solrClient);
    }

    public void indexProjectResources(ResourceCollection collection, Project project, SolrClient solrClient) throws Exception {
        this.indexProjectResources(collection, project, solrClient, ProgressionTrackerFactory.createSimpleProgressionTracker((String)("Index project '" + project.getName() + "' resources"), (Logger)this.getLogger()));
    }

    public void indexProjectResources(ResourceCollection collection, Project project, SolrClient solrClient, SimpleProgressionTracker progressionTracker) throws Exception {
        if (collection == null) {
            return;
        }
        try (AmetysObjectIterable children = collection.getChildren();){
            long nbOfDocuments = children.getSize();
            progressionTracker.setSize(nbOfDocuments);
            for (AmetysObject object : children) {
                if (object instanceof ResourceCollection) {
                    this.indexProjectResources((ResourceCollection)object, project, solrClient);
                } else if (object instanceof Resource) {
                    this._indexProjectResource((Resource)object, project, solrClient);
                }
                progressionTracker.increment();
            }
        }
    }

    public void indexProjectResource(Resource resource, Project project, String workspaceName) throws Exception {
        SolrClient solrClient = this._solrClientProvider.getUpdateClient(workspaceName, true);
        this._indexProjectResource(resource, project, solrClient);
    }

    private void _indexProjectResource(Resource resource, Project project, SolrClient solrClient) throws Exception {
        SolrInputDocument solrDocument = new SolrInputDocument();
        this._indexProjectResource(resource, solrDocument, project);
        this._indexResourceSolrDocument(resource, solrDocument, solrClient);
    }

    private void _indexProjectResource(Resource resource, SolrInputDocument document, Project project) throws Exception {
        this._solrResourceIndexer.indexResource(resource, document, "projectResource");
        Site site = project.getSite();
        if (site != null) {
            document.addField("site", (Object)site.getName());
            document.addField("siteType", (Object)site.getType());
        }
        document.addField("workspace-projectId", (Object)project.getId());
        document.setField("workspace-keywords", (Object)resource.getKeywords());
    }

    private void _indexResourceSolrDocument(Resource resource, SolrInputDocument document, SolrClient solrClient) throws SolrServerException, IOException {
        UpdateResponse solrResponse = solrClient.add(this._solrClientProvider.getCollectionName(), document);
        int status = solrResponse.getStatus();
        if (status != 0) {
            throw new IOException("Ametys resource indexing - Expecting status code of '0' in the Solr response but got : '" + status + "'. Resource id : " + resource.getId());
        }
        this.getLogger().debug("Successful resource indexing. Resource identifier : {}", (Object)resource.getId());
    }
}

