/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.initialization;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.user.directory.ModifiableUserDirectory;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.workspaces.initialization.DefaultStaticPageInitializer;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.ModifiableSitemapElement;
import org.ametys.web.repository.page.ModifiableZone;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageDAO;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class UserSignupPageInitializer
extends DefaultStaticPageInitializer {
    protected PopulationContextHelper _populationContextHelper;
    protected UserPopulationDAO _userPopulationDAO;
    protected PageDAO _pageDAO;
    protected AmetysObjectResolver _resolver;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._pageDAO = (PageDAO)manager.lookup(PageDAO.ROLE);
        this._populationContextHelper = (PopulationContextHelper)manager.lookup(PopulationContextHelper.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)manager.lookup(UserPopulationDAO.ROLE);
    }

    @Override
    public Optional<? extends Page> createPage(ModifiableSitemapElement parent) {
        Page page;
        Optional<? extends Page> result = super.createPage(parent);
        if (result.isPresent() && (page = result.get()) instanceof ModifiablePage) {
            ModifiablePage page2 = (ModifiablePage)page;
            try (AmetysObjectIterable zones = page2.getZones();){
                for (ModifiableZone zone : zones) {
                    AmetysObjectIterable zoneItems = zone.getZoneItems();
                    try {
                        for (ModifiableZoneItem zoneItem : zoneItems) {
                            if (!StringUtils.equals((CharSequence)zoneItem.getServiceId(), (CharSequence)"org.ametys.web.service.UserSignup")) continue;
                            ModifiableModelAwareDataHolder serviceParams = zoneItem.getServiceParameters();
                            Optional<Content> termsOfUseContent = this._getTermsOfUseContent(parent);
                            if (termsOfUseContent.isPresent()) {
                                serviceParams.setValue("terms-of-service-content", (Object)termsOfUseContent.get().getId());
                            }
                            Set frontPopulations = this._populationContextHelper.getUserPopulationsOnContexts(List.of("/sites-fo/" + parent.getSiteName(), "/sites/" + parent.getSiteName()), false);
                            Optional<UserDirectory> userDirectory = frontPopulations.stream().map(arg_0 -> ((UserPopulationDAO)this._userPopulationDAO).getUserPopulation(arg_0)).map(UserPopulation::getUserDirectories).flatMap(Collection::stream).filter(ModifiableUserDirectory.class::isInstance).findAny();
                            if (userDirectory.isPresent()) {
                                serviceParams.setValue("userdirectory", (Object)(userDirectory.get().getPopulationId() + "#" + userDirectory.get().getId()));
                            } else {
                                this.getLogger().warn("No user directory found to set on the signup services. Consider configuring one or remove the sign up page.");
                            }
                            zoneItem.saveChanges();
                            HashMap<String, Object> eventParams = new HashMap<String, Object>();
                            eventParams.put("zone.item", zoneItem);
                            eventParams.put("zone.item.id", zoneItem.getId());
                            eventParams.put("zone.item.service", zoneItem.getServiceId());
                            this._observationManager.notify(new Event("service.modified", this._currentUserProvider.getUser(), eventParams));
                        }
                    }
                    finally {
                        if (zoneItems == null) continue;
                        zoneItems.close();
                    }
                }
            }
            page2.saveChanges();
        }
        return result;
    }

    private Optional<Content> _getTermsOfUseContent(ModifiableSitemapElement parent) {
        Iterator iterator = this._pageDAO.findPagedIdsByTag(parent.getSiteName(), parent.getSitemapName(), "WORKSPACES_CGU").iterator();
        if (iterator.hasNext()) {
            String pageId = (String)iterator.next();
            Page page = (Page)this._resolver.resolveById(pageId);
            try (AmetysObjectIterable zones = page.getZones();){
                Optional<Content> optional = zones.stream().flatMap(zone -> zone.getZoneItems().stream()).filter(items -> items.getType().equals((Object)ZoneItem.ZoneType.CONTENT)).map(ZoneItem::getContent).findAny();
                return optional;
            }
        }
        return Optional.empty();
    }
}

