/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.members;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ametys.cms.languages.Language;
import org.ametys.cms.languages.LanguagesManager;
import org.ametys.cms.repository.Content;
import org.ametys.cms.transformation.URIResolverExtensionPoint;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupDirectoryContextHelper;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.observation.AsyncObserver;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.observation.Observer;
import org.ametys.core.right.ProfileAssignmentStorage;
import org.ametys.core.right.ProfileAssignmentStorageExtensionPoint;
import org.ametys.core.right.RightManager;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.plugins.core.impl.cache.AbstractCacheKey;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.UserExpression;
import org.ametys.plugins.userdirectory.UserDirectoryHelper;
import org.ametys.plugins.userdirectory.page.UserDirectoryPageResolver;
import org.ametys.plugins.userdirectory.page.UserPage;
import org.ametys.plugins.workspaces.WorkspacesHelper;
import org.ametys.plugins.workspaces.documents.DocumentWorkspaceModule;
import org.ametys.plugins.workspaces.forum.ForumWorkspaceModule;
import org.ametys.plugins.workspaces.members.JCRProjectMember;
import org.ametys.plugins.workspaces.members.MembersWorkspaceModule;
import org.ametys.plugins.workspaces.members.ProjectInvitationHelper;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.ProjectsCatalogueManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModule;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.project.rights.ProjectRightHelper;
import org.ametys.plugins.workspaces.tasks.TasksWorkspaceModule;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.WebHelper;
import org.ametys.web.population.PopulationContextHelper;
import org.ametys.web.repository.site.Site;
import org.ametys.web.usermanagement.UserManagementException;
import org.ametys.web.usermanagement.UserSignupManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.annotation.Obsolete;

public class ProjectMemberManager
extends AbstractLogEnabled
implements Serviceable,
Component,
Contextualizable,
Initializable,
AsyncObserver,
Disposable {
    public static final String ROLE = ProjectMemberManager.class.getName();
    public static final String __WORKSPACES_SERVICE_MEMBERS = "org.ametys.plugins.workspaces.module.Members";
    private static final String __PROJECT_MEMBER_CACHE = "projectMemberCache";
    @Obsolete
    private static final String __PROJECT_RIGHT_PROFILE = "PROJECT";
    private static final String __PROJECT_MEMBERS_NODE = "ametys-internal:members";
    private static final String __PROJECT_MEMBERS_NODE_TYPE = "ametys:unstructured";
    private static final String __PROJECT_MEMBER_NODE_TYPE = "ametys:project-member";
    private static Pattern __MAIL_BETWEEN_BRACKETS_PATTERN = Pattern.compile("^[^<]*<(.*@.*)>$");
    protected Context _context;
    protected ProjectManager _projectManager;
    protected ProjectRightHelper _projectRightHelper;
    protected RightProfilesDAO _rightProfilesDAO;
    protected ProfileAssignmentStorageExtensionPoint _profileAssignmentStorageExtensionPoint;
    protected AmetysObjectResolver _resolver;
    protected RightManager _rightManager;
    protected CurrentUserProvider _currentUserProvider;
    protected UserManager _userManager;
    protected ObservationManager _observationManager;
    protected WorkspaceModuleExtensionPoint _moduleManagerEP;
    protected UserHelper _userHelper;
    protected GroupManager _groupManager;
    protected PopulationContextHelper _populationContextHelper;
    protected UserDirectoryHelper _userDirectoryHelper;
    protected ProjectInvitationHelper _projectInvitationHelper;
    protected LanguagesManager _languagesManager;
    protected UserDirectoryPageResolver _userDirectoryPageResolver;
    protected URIResolverExtensionPoint _uriResolver;
    protected GroupDirectoryContextHelper _groupDirectoryContextHelper;
    protected AbstractCacheManager _abstractCacheManager;
    protected UserSignupManager _userSignupManager;
    protected ProjectsCatalogueManager _projectsCatalogueManager;
    protected ProjectRightHelper _projectRightsHelper;
    protected WorkspacesHelper _workspaceHelper;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._abstractCacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._projectRightHelper = (ProjectRightHelper)((Object)manager.lookup(ProjectRightHelper.ROLE));
        this._rightProfilesDAO = (RightProfilesDAO)manager.lookup(RightProfilesDAO.ROLE);
        this._profileAssignmentStorageExtensionPoint = (ProfileAssignmentStorageExtensionPoint)manager.lookup(ProfileAssignmentStorageExtensionPoint.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._groupManager = (GroupManager)manager.lookup(GroupManager.ROLE);
        this._userHelper = (UserHelper)manager.lookup(UserHelper.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._moduleManagerEP = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._populationContextHelper = (PopulationContextHelper)manager.lookup(org.ametys.core.user.population.PopulationContextHelper.ROLE);
        this._userDirectoryHelper = (UserDirectoryHelper)manager.lookup(UserDirectoryHelper.ROLE);
        this._projectInvitationHelper = (ProjectInvitationHelper)((Object)manager.lookup(ProjectInvitationHelper.ROLE));
        this._languagesManager = (LanguagesManager)manager.lookup(LanguagesManager.ROLE);
        this._userDirectoryPageResolver = (UserDirectoryPageResolver)manager.lookup(UserDirectoryPageResolver.ROLE);
        this._uriResolver = (URIResolverExtensionPoint)manager.lookup(URIResolverExtensionPoint.ROLE);
        this._groupDirectoryContextHelper = (GroupDirectoryContextHelper)manager.lookup(GroupDirectoryContextHelper.ROLE);
        this._userSignupManager = (UserSignupManager)manager.lookup(UserSignupManager.ROLE);
        this._projectsCatalogueManager = (ProjectsCatalogueManager)((Object)manager.lookup(ProjectsCatalogueManager.ROLE));
        this._projectRightsHelper = (ProjectRightHelper)((Object)manager.lookup(ProjectRightHelper.ROLE));
        this._workspaceHelper = (WorkspacesHelper)((Object)manager.lookup(WorkspacesHelper.ROLE));
    }

    public void initialize() throws Exception {
        this._abstractCacheManager.createMemoryCache(__PROJECT_MEMBER_CACHE, new I18nizableText("plugin.workspaces", "PLUGIN_WORKSPACES_CACHE_PROJECT_MEMBER_LABEL"), new I18nizableText("plugin.workspaces", "PLUGIN_WORKSPACES_CACHE_PROJECT_MEMBER_DESCRIPTION"), true, null);
        this._observationManager.registerObserver((Observer)this);
    }

    public void dispose() {
        this._observationManager.unregisterObserver((Observer)this);
    }

    @Callable(rights={""})
    public Map<String, Object> getProjectMemberData(String projectName, String identity, String type) {
        Map<Object, Object> userProfiles;
        Project project = this._projectManager.getProject(projectName);
        if (!this._projectRightHelper.canEditMember(project)) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to get member's rights without convenient right [" + projectName + ", " + identity + "]");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean isTypeUser = JCRProjectMember.MemberType.USER.name().equals(type.toUpperCase());
        boolean isTypeGroup = JCRProjectMember.MemberType.GROUP.name().equals(type.toUpperCase());
        UserIdentity user = Optional.ofNullable(identity).filter(id -> id != null && isTypeUser).map(UserIdentity::stringToUserIdentity).orElse(null);
        GroupIdentity group = Optional.ofNullable(identity).filter(id -> id != null && isTypeGroup).map(GroupIdentity::stringToGroupIdentity).orElse(null);
        if (identity != null) {
            if (isTypeGroup && group == null) {
                result.put("message", "unknown-group");
                result.put("success", false);
                return result;
            }
            if (isTypeUser && user == null) {
                result.put("message", "unknown-user");
                result.put("success", false);
                return result;
            }
        }
        boolean newMember = true;
        if (user != null || group != null) {
            JCRProjectMember projectMember = user != null ? this._getOrCreateJCRProjectMember(project, user) : this._getOrCreateJCRProjectMember(project, group);
            newMember = projectMember.needsSave();
            String role = projectMember.getRole();
            if (role != null) {
                result.put("role", role);
            }
            userProfiles = this._getMemberProfiles(projectMember, project);
        } else {
            userProfiles = new HashMap();
        }
        result.put("profiles", userProfiles);
        result.put("status", newMember ? "new" : "edit");
        result.put("success", true);
        return result;
    }

    private Map<String, String> _getMemberProfiles(JCRProjectMember member, Project project) {
        HashMap<String, String> userProfiles = new HashMap<String, String>();
        for (WorkspaceModule module : this._projectManager.getModules(project)) {
            String allowedProfileOnProject = this._getAllowedProfileOnModule(project, module, member);
            userProfiles.put(module.getId(), allowedProfileOnProject);
        }
        return userProfiles;
    }

    private String _getAllowedProfileOnModule(Project project, WorkspaceModule module, JCRProjectMember member) {
        Set<String> profileIds = this._projectRightHelper.getProfilesIds();
        ModifiableResourceCollection moduleObject = module.getModuleRoot(project, false);
        Set<String> allowedProfilesForMember = this._getAllowedProfile(member, (AmetysObject)moduleObject);
        for (String allowedProfile : allowedProfilesForMember) {
            if (!profileIds.contains(allowedProfile)) continue;
            return allowedProfile;
        }
        return null;
    }

    @Callable(rights={""})
    public Map<String, Object> addMembers(String projectName, List<Map<String, String>> newMembers, List<String> invitEmails) {
        Project project = this._projectManager.getProject(projectName);
        if (!this._projectRightHelper.canAddMember(project)) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried perform operation without convenient right");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Request request = ContextHelper.getRequest((Context)this._context);
        String siteName = WebHelper.getSiteName((Request)request);
        boolean hasError = false;
        boolean inviteError = false;
        boolean unknownProject = false;
        ArrayList<String> unknownGroups = new ArrayList<String>();
        ArrayList<String> unknownUsers = new ArrayList<String>();
        ArrayList<Map> existingUsers = new ArrayList<Map>();
        ArrayList<Map> membersAdded = new ArrayList<Map>();
        ArrayList<String> filteredInvitEmails = new ArrayList<String>();
        if (invitEmails != null) {
            try {
                Iterator<String> iterator = invitEmails.iterator();
                while (iterator.hasNext()) {
                    Optional userIfExists;
                    String invitEmail;
                    String filteredInvitEmail = invitEmail = iterator.next();
                    Matcher matcher = __MAIL_BETWEEN_BRACKETS_PATTERN.matcher(invitEmail);
                    if (matcher.matches() && matcher.groupCount() == 1) {
                        filteredInvitEmail = matcher.group(1);
                    }
                    if ((userIfExists = this._userSignupManager.getUserIfHeExists(filteredInvitEmail, siteName)).isPresent()) {
                        newMembers.add(Map.of("id", UserIdentity.userIdentityToString((UserIdentity)((User)userIfExists.get()).getIdentity()), "type", "user"));
                        continue;
                    }
                    filteredInvitEmails.add(filteredInvitEmail);
                }
            }
            catch (UserManagementException e) {
                hasError = true;
                inviteError = true;
                this.getLogger().error("Impossible to send email invitations", (Throwable)e);
            }
            catch (NotUniqueUserException e) {
                hasError = true;
                inviteError = true;
                this.getLogger().error("Impossible to send email invitations, some user already exist", (Throwable)e);
            }
        }
        for (Map<String, String> newMember : newMembers) {
            Map<String, Object> addResult = this.addMember(projectName, newMember.get("id"), newMember.get("type"));
            boolean success = (Boolean)addResult.get("success");
            if (!success) {
                String error = (String)addResult.get("message");
                if ("unknown-user".equals(error)) {
                    hasError = true;
                    unknownUsers.add(newMember.get("id"));
                    continue;
                }
                if ("unknown-group".equals(error)) {
                    hasError = true;
                    unknownGroups.add(newMember.get("id"));
                    continue;
                }
                if ("unknown-project".equals(error)) {
                    hasError = true;
                    unknownProject = true;
                    continue;
                }
                if (!"existing-user".equals(error)) continue;
                existingUsers.add((Map)addResult.get("existing-user"));
                continue;
            }
            membersAdded.add((Map)addResult.get("member"));
        }
        if (!filteredInvitEmails.isEmpty()) {
            Map<String, String> newProfiles = this._getDefaultProfilesByModule();
            try {
                Map<String, Object> inviteEmails = this._projectInvitationHelper.inviteEmails(projectName, filteredInvitEmails, newProfiles);
                List errors = (List)inviteEmails.get("email-error");
                if (!errors.isEmpty()) {
                    hasError = true;
                    inviteError = true;
                }
                existingUsers.addAll((List)inviteEmails.get("existing-users"));
            }
            catch (UserManagementException e) {
                hasError = true;
                inviteError = true;
                this.getLogger().error("Impossible to send email invitations", (Throwable)e);
            }
            catch (NotUniqueUserException e) {
                hasError = true;
                inviteError = true;
                this.getLogger().error("Impossible to send email invitations, some user already exist", (Throwable)e);
            }
        }
        result.put("invite-error", inviteError);
        result.put("existing-users", existingUsers);
        result.put("unknown-groups", unknownGroups);
        result.put("unknown-users", unknownUsers);
        result.put("unknown-project", unknownProject);
        result.put("members-added", membersAdded);
        result.put("success", !hasError);
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> addMember(String projectName, String identity, String type) {
        Map<String, String> newProfiles = this._getDefaultProfilesByModule();
        return this._setProjectMemberData(projectName, identity, type, newProfiles, null, true);
    }

    protected Map<String, String> _getDefaultProfilesByModule() {
        HashMap<String, String> newProfiles = new HashMap<String, String>();
        String defaultProfile = StringUtils.defaultString((String)((String)Config.getInstance().getValue("workspaces.profile.default")));
        for (String moduleId : this._moduleManagerEP.getExtensionsIds()) {
            newProfiles.put(moduleId, defaultProfile);
        }
        return newProfiles;
    }

    @Callable(rights={""})
    public Map<String, Object> setProjectMemberData(String projectName, String identity, String type, Map<String, String> newProfiles, String role) {
        return this._setProjectMemberData(projectName, identity, type, newProfiles, role, false);
    }

    protected Map<String, Object> _setProjectMemberData(String projectName, String identity, String type, Map<String, String> newProfiles, String role, boolean isNewUser) {
        JCRProjectMember projectMember;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this._projectManager.getProject(projectName);
        if (isNewUser && !this._projectRightHelper.canAddMember(project) || !isNewUser && !this._projectRightHelper.canEditMember(project)) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to set member rights without convenient right [" + projectName + ", " + identity + "]");
        }
        boolean isTypeUser = JCRProjectMember.MemberType.USER.name().equals(type.toUpperCase());
        boolean isTypeGroup = JCRProjectMember.MemberType.GROUP.name().equals(type.toUpperCase());
        UserIdentity user = Optional.ofNullable(identity).filter(id -> id != null && isTypeUser).map(UserIdentity::stringToUserIdentity).orElse(null);
        GroupIdentity group = Optional.ofNullable(identity).filter(id -> id != null && isTypeGroup).map(GroupIdentity::stringToGroupIdentity).orElse(null);
        if (group == null && user == null) {
            result.put("success", false);
            result.put("message", isTypeGroup ? "unknown-group" : "unknown-user");
            return result;
        }
        if (isNewUser && isTypeUser && this._getProjectMember(project, user) != null) {
            result.put("success", false);
            result.put("message", "existing-user");
            result.put("existing-user", this._userHelper.user2json(user, true));
            return result;
        }
        JCRProjectMember jCRProjectMember = projectMember = isTypeUser ? this.addOrUpdateProjectMember(project, user, newProfiles) : this.addOrUpdateProjectMember(project, group, newProfiles);
        if (projectMember != null) {
            Request request = ContextHelper.getRequest((Context)this._context);
            String lang = (String)request.getAttribute("sitemapLanguage");
            ProjectMember member = isTypeUser ? new ProjectMember(this._userManager.getUser(user), projectMember.getRole(), false) : new ProjectMember(this._groupManager.getGroup(group));
            result.put("member", this._member2Json(member, lang));
        }
        result.put("success", projectMember != null);
        return result;
    }

    public JCRProjectMember addProjectMember(Project project, UserIdentity user) {
        Project.InscriptionStatus inscriptionStatus = project.getInscriptionStatus();
        if (!inscriptionStatus.equals((Object)Project.InscriptionStatus.OPEN)) {
            return null;
        }
        return this.addOrUpdateProjectMember(project, user, Map.of());
    }

    public JCRProjectMember addOrUpdateProjectMember(Project project, UserIdentity user, Map<String, String> allowedProfiles) {
        return this.addOrUpdateProjectMember(project, user, allowedProfiles, this._currentUserProvider.getUser());
    }

    public JCRProjectMember addOrUpdateProjectMember(Project project, UserIdentity user, Map<String, String> allowedProfiles, UserIdentity issuer) {
        if (user == null) {
            return null;
        }
        JCRProjectMember projectMember = this._getOrCreateJCRProjectMember(project, user);
        this._setMemberProfiles(allowedProfiles, projectMember, project);
        this._saveAndNotifyProjectMemberUpdate(project, projectMember, UserIdentity.userIdentityToString((UserIdentity)user), issuer);
        return projectMember;
    }

    public JCRProjectMember addOrUpdateProjectMember(Project project, GroupIdentity group, Map<String, String> allowedProfiles) {
        if (group == null) {
            return null;
        }
        JCRProjectMember projectMember = this._getOrCreateJCRProjectMember(project, group);
        this._setMemberProfiles(allowedProfiles, projectMember, project);
        this._saveAndNotifyProjectMemberUpdate(project, projectMember, GroupIdentity.groupIdentityToString((GroupIdentity)group), this._currentUserProvider.getUser());
        return projectMember;
    }

    private void _saveAndNotifyProjectMemberUpdate(Project project, JCRProjectMember projectMember, String userIdentityString, UserIdentity issuer) {
        project.saveChanges();
        this._getCache().invalidate((Object)ProjectMemberCacheKey.of(project.getId(), null));
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("project.member", (Object)projectMember);
        eventParams.put("project.member.id", projectMember.getId());
        eventParams.put("project", (Object)project);
        eventParams.put("projectId", project.getId());
        eventParams.put("project.member.identity", userIdentityString);
        eventParams.put("project.member.identity.type", (Object)projectMember.getType());
        this._observationManager.notify(new Event("member.added", issuer, eventParams));
    }

    private void _setMemberProfiles(Map<String, String> newProfiles, JCRProjectMember projectMember, Project project) {
        String defaultProfile = project.getDefaultProfile();
        Set<Object> defaultProfiles = StringUtils.isEmpty((CharSequence)defaultProfile) ? Set.of() : Set.of(defaultProfile);
        for (WorkspaceModule module : this._moduleManagerEP.getModules()) {
            String profile;
            Set<Object> moduleProfiles = newProfiles.containsKey(module.getId()) ? (StringUtils.isEmpty((CharSequence)(profile = newProfiles.get(module.getId()))) ? Set.of() : Set.of(profile)) : defaultProfiles;
            this.setProfileOnModule(projectMember, project, module, moduleProfiles);
        }
    }

    public void setProfileOnModule(JCRProjectMember member, Project project, WorkspaceModule module, Set<String> allowedProfiles) {
        if (module != null && this._projectManager.isModuleActivated(project, module.getId())) {
            ModifiableResourceCollection moduleObject = module.getModuleRoot(project, false);
            this._setMemberProfiles(member, allowedProfiles, (AmetysObject)moduleObject);
        }
    }

    private Set<String> _getAllowedProfile(JCRProjectMember member, AmetysObject object) {
        if (JCRProjectMember.MemberType.GROUP == member.getType()) {
            Map profilesForGroups = this._profileAssignmentStorageExtensionPoint.getProfilesForGroups((Object)object, Set.of(member.getGroup()));
            return Optional.ofNullable((Map)profilesForGroups.get(member.getGroup())).map(a -> (Set)a.get(ProfileAssignmentStorage.UserOrGroup.ALLOWED)).orElse(Set.of());
        }
        Map profilesForUsers = this._profileAssignmentStorageExtensionPoint.getProfilesForUsers((Object)object, member.getUser());
        return Optional.ofNullable((Map)profilesForUsers.get(member.getUser())).map(a -> (Set)a.get(ProfileAssignmentStorage.UserOrGroup.ALLOWED)).orElse(Set.of());
    }

    private void _setMemberProfiles(JCRProjectMember member, Set<String> allowedProfiles, AmetysObject object) {
        Set<String> currentAllowedProfiles = this._getAllowedProfile(member, object);
        Collection profilesToRemove = CollectionUtils.removeAll(currentAllowedProfiles, allowedProfiles);
        Collection profilesToAdd = CollectionUtils.removeAll(allowedProfiles, currentAllowedProfiles);
        for (String profileId : profilesToRemove) {
            this._removeProfile(member, profileId, object);
        }
        for (String profileId : profilesToAdd) {
            this._addProfile(member, profileId, object);
        }
        Collection updatedProfiles = CollectionUtils.union((Collection)profilesToAdd, (Collection)profilesToRemove);
        if (updatedProfiles.size() > 0) {
            this._notifyAclUpdated(this._currentUserProvider.getUser(), object, updatedProfiles);
        }
    }

    private void _removeProfile(JCRProjectMember member, String profileId, AmetysObject aclObject) {
        if (JCRProjectMember.MemberType.GROUP == member.getType()) {
            this._profileAssignmentStorageExtensionPoint.removeAllowedProfileFromGroup(member.getGroup(), profileId, (Object)aclObject);
        } else {
            this._profileAssignmentStorageExtensionPoint.removeAllowedProfileFromUser(member.getUser(), profileId, (Object)aclObject);
        }
    }

    private void _addProfile(JCRProjectMember member, String profileId, AmetysObject aclObject) {
        if (JCRProjectMember.MemberType.GROUP == member.getType()) {
            this._profileAssignmentStorageExtensionPoint.allowProfileToGroup(member.getGroup(), profileId, (Object)aclObject);
        } else {
            this._profileAssignmentStorageExtensionPoint.allowProfileToUser(member.getUser(), profileId, (Object)aclObject);
        }
    }

    private void _removeMemberProfiles(JCRProjectMember member, AmetysObject object) {
        Set<String> currentAllowedProfiles = this._getAllowedProfile(member, object);
        for (String allowedProfile : currentAllowedProfiles) {
            this._removeProfile(member, allowedProfile, object);
        }
        if (currentAllowedProfiles.size() > 0) {
            ((ModifiableAmetysObject)object).saveChanges();
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            eventParams.put("acl-context", object);
            eventParams.put("acl-context-identifier", object.getId());
            eventParams.put("acl-profiles", currentAllowedProfiles);
            eventParams.put("acl-solr-cache-uninfluential", true);
            this._observationManager.notify(new Event("acl.update", this._currentUserProvider.getUser(), eventParams));
        }
    }

    @Callable(rights={""})
    public Map<String, Object> getProjectMembers(String projectName, String lang) throws IllegalAccessException, AmetysRepositoryException {
        return this.getProjectMembers(projectName, lang, false);
    }

    @Callable(rights={""})
    public Map<String, Object> getProjectMembers(String projectName, String lang, boolean expandGroup) throws AmetysRepositoryException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this._projectManager.getProject(projectName);
        if (!this._projectRightHelper.hasReadAccess(project)) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to do read operation without convenient right");
        }
        ArrayList<Map<String, Object>> membersData = new ArrayList<Map<String, Object>>();
        Set<ProjectMember> projectMembers = this.getProjectMembers(project, expandGroup);
        for (ProjectMember projectMember : projectMembers) {
            membersData.add(this._member2Json(projectMember, lang));
        }
        result.put("members", membersData);
        result.put("success", true);
        return result;
    }

    private Map<String, Object> _member2Json(ProjectMember projectMember, String lang) {
        Group group;
        User user;
        Project project = this._workspaceHelper.getProjectFromRequest();
        HashMap<String, Object> memberData = new HashMap<String, Object>();
        memberData.put("type", projectMember.getType().name().toLowerCase());
        memberData.put("title", projectMember.getTitle());
        memberData.put("sortabletitle", projectMember.getSortableTitle());
        memberData.put("manager", projectMember.isManager());
        String role = projectMember.getRole();
        if (StringUtils.isNotEmpty((CharSequence)role)) {
            memberData.put("role", role);
        }
        if ((user = projectMember.getUser()) != null) {
            memberData.put("id", UserIdentity.userIdentityToString((UserIdentity)user.getIdentity()));
            memberData.putAll(this._userHelper.user2json(user));
            Content userContent = this.getUserContent(lang, user);
            if (userContent != null) {
                String[] contentTypes;
                if (userContent.hasValue("function")) {
                    memberData.put("function", userContent.getValue("function"));
                }
                if (userContent.hasValue("organisation-accronym")) {
                    memberData.put("organisationAcronym", userContent.getValue("organisation-accronym"));
                }
                String usersDirectorySiteName = this._projectManager.getUsersDirectorySiteName();
                for (String contentType : contentTypes = userContent.getTypes()) {
                    UserPage userPage = this._userDirectoryPageResolver.getUserPage(userContent, usersDirectorySiteName, lang, contentType);
                    if (userPage == null) continue;
                    memberData.put("link", this._uriResolver.getResolverForType("page").resolve(userPage.getId(), false, true, false));
                }
            } else if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("User content not found for user : " + String.valueOf(user));
            }
            memberData.put("hasReadAccessOnTaskModule", this._projectRightsHelper.hasReadAccessOnModule(project, TasksWorkspaceModule.TASK_MODULE_ID, user.getIdentity()));
            memberData.put("hasReadAccessOnDocumentModule", this._projectRightsHelper.hasReadAccessOnModule(project, DocumentWorkspaceModule.DOCUMENT_MODULE_ID, user.getIdentity()));
            memberData.put("hasReadAccessOnForumModule", this._projectRightsHelper.hasReadAccessOnModule(project, ForumWorkspaceModule.FORUM_MODULE_ID, user.getIdentity()));
        }
        if ((group = projectMember.getGroup()) != null) {
            memberData.putAll(this.group2Json(group));
        }
        return memberData;
    }

    public Content getUserContent(String lang, User user) {
        Content userContent = this._userDirectoryHelper.getUserContent(user.getIdentity(), lang);
        if (userContent == null) {
            userContent = this._userDirectoryHelper.getUserContent(user.getIdentity(), "en");
        }
        if (userContent == null) {
            Map availableLanguages = this._languagesManager.getAvailableLanguages();
            for (Language availableLanguage : availableLanguages.values()) {
                if (userContent != null) continue;
                userContent = this._userDirectoryHelper.getUserContent(user.getIdentity(), availableLanguage.getCode());
            }
        }
        return userContent;
    }

    public Set<ProjectMember> getProjectMembers(Project project, boolean expandGroup) throws AmetysRepositoryException {
        return this.getProjectMembers(project, expandGroup, Set.of());
    }

    public Set<ProjectMember> getProjectMembers(Project project, boolean expandGroup, Set<ProjectMember> defaultSet) throws AmetysRepositoryException {
        Cache<ProjectMemberCacheKey, Set<ProjectMember>> cache = this._getCache();
        if (project == null) {
            return defaultSet;
        }
        ProjectMemberCacheKey cacheKey = ProjectMemberCacheKey.of(project.getId(), expandGroup);
        if (cache.hasKey((Object)cacheKey)) {
            Set<ProjectMember> projectMembers = (Set<ProjectMember>)cache.get((Object)cacheKey);
            return projectMembers != null ? projectMembers : defaultSet;
        }
        Set<ProjectMember> projectMembers = this._getProjectMembers(project, expandGroup);
        cache.put((Object)cacheKey, projectMembers);
        return projectMembers != null ? projectMembers : defaultSet;
    }

    private Set<ProjectMember> _getProjectMembers(Project project, boolean expandGroup) {
        Comparator<ProjectMember> managerComparator = Comparator.comparing(m -> m.isManager() ? 0 : 1);
        Comparator<ProjectMember> roleComparator = Comparator.comparing(m -> StringUtils.isNotBlank((CharSequence)m.getRole()) ? 0 : 1);
        Comparator nameComparator = (m1, m2) -> (m1.getSortableTitle() + m1.hashCode()).compareToIgnoreCase(m2.getSortableTitle() + m2.hashCode());
        TreeSet<ProjectMember> members = new TreeSet<ProjectMember>(managerComparator.thenComparing(roleComparator).thenComparing(nameComparator));
        Map<JCRProjectMember, Object> jcrMembers = this.getJCRProjectMembers(project);
        List<UserIdentity> managers = Arrays.asList(project.getManagers());
        Site site = project.getSite();
        if (site == null) {
            this.getLogger().error("Can not compute members in the project " + project.getName() + " because it can not be linked to an existing site");
            return null;
        }
        String projectSiteName = site.getName();
        Set projectGroupDirectory = this._groupDirectoryContextHelper.getGroupDirectoriesOnContext("/sites/" + projectSiteName);
        for (Map.Entry<JCRProjectMember, Object> entry : jcrMembers.entrySet()) {
            Group group;
            JCRProjectMember jcrMember = entry.getKey();
            if (JCRProjectMember.MemberType.USER == jcrMember.getType()) {
                User user = (User)entry.getValue();
                boolean isManager = managers.contains(jcrMember.getUser());
                ProjectMember projectMember = new ProjectMember(user, jcrMember.getRole(), isManager);
                if (members.add(projectMember) || !this._projectManager.isUserInProjectPopulations(project, user.getIdentity())) continue;
                members.remove(projectMember);
                members.add(projectMember);
                continue;
            }
            if (JCRProjectMember.MemberType.GROUP != jcrMember.getType() || !projectGroupDirectory.contains((group = (Group)entry.getValue()).getGroupDirectory().getId())) continue;
            if (expandGroup) {
                for (UserIdentity userIdentity : group.getUsers()) {
                    User user = this._userManager.getUser(userIdentity);
                    if (user == null || !this._projectManager.isUserInProjectPopulations(project, userIdentity)) continue;
                    ProjectMember projectMember = new ProjectMember(user, null, false);
                    members.add(projectMember);
                }
                continue;
            }
            members.add(new ProjectMember(group));
        }
        return members;
    }

    @Callable(rights={""})
    public Map<String, Object> getMemberModuleRights(String projectName) {
        if (!this._projectRightsHelper.hasReadAccessOnModule(MembersWorkspaceModule.MEMBERS_MODULE_ID)) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to do read operation without convenient right");
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        HashMap<String, Boolean> rights = new HashMap<String, Boolean>();
        Project project = this._projectManager.getProject(projectName);
        if (project == null) {
            results.put("message", "unknown-project");
            results.put("success", false);
        } else {
            rights.put("view", this._projectRightHelper.canViewMembers(project));
            rights.put("add", this._projectRightHelper.canAddMember(project));
            rights.put("edit", this._projectRightHelper.canEditMember(project));
            rights.put("delete", this._projectRightHelper.canRemoveMember(project));
            results.put("rights", rights);
            results.put("success", true);
        }
        return results;
    }

    public Map<JCRProjectMember, Object> getJCRProjectMembers(Project project) {
        HashMap<JCRProjectMember, Object> projectMembers = new HashMap<JCRProjectMember, Object>();
        if (project != null) {
            ModifiableTraversableAmetysObject membersNode = this._getProjectMembersNode(project);
            for (AmetysObject memberNode : membersNode.getChildren()) {
                if (!(memberNode instanceof JCRProjectMember)) continue;
                JCRProjectMember jCRProjectMember = (JCRProjectMember)memberNode;
                if (jCRProjectMember.getType() == JCRProjectMember.MemberType.USER) {
                    UserIdentity userIdentity = jCRProjectMember.getUser();
                    User user = this._userManager.getUser(userIdentity);
                    if (user == null) continue;
                    projectMembers.put((JCRProjectMember)memberNode, user);
                    continue;
                }
                GroupIdentity groupIdentity = jCRProjectMember.getGroup();
                Group group = this._groupManager.getGroup(groupIdentity);
                if (group == null) continue;
                projectMembers.put((JCRProjectMember)memberNode, group);
            }
        }
        return projectMembers;
    }

    public boolean isProjectMember(Project project, UserIdentity userIdentity) {
        return this.getProjectMember(project, userIdentity) != null;
    }

    public ProjectMember getProjectMember(Project project, UserIdentity userIdentity) {
        return this.getProjectMember(project, userIdentity, null);
    }

    public ProjectMember getProjectMember(Project project, UserIdentity userIdentity, Set<GroupIdentity> userGroups) {
        Set groups;
        if (userIdentity == null) {
            return null;
        }
        Set<ProjectMember> members = this.getProjectMembers(project, true);
        ProjectMember projectMember = members.stream().filter(member -> JCRProjectMember.MemberType.USER == member.getType()).filter(member -> userIdentity.equals((Object)member.getUser().getIdentity())).findFirst().orElse(null);
        if (projectMember != null) {
            return projectMember;
        }
        Set set = groups = userGroups == null ? this._groupManager.getUserGroups(userIdentity) : userGroups;
        if (!groups.isEmpty()) {
            return members.stream().filter(member -> JCRProjectMember.MemberType.GROUP == member.getType()).filter(member -> groups.contains(member.getGroup().getIdentity())).findFirst().orElse(null);
        }
        return null;
    }

    public void setProjectManager(String projectName, String profileId, List<UserIdentity> managers) {
        Project project = this._projectManager.getProject(projectName);
        if (project == null) {
            return;
        }
        project.setManagers(managers.toArray(new UserIdentity[managers.size()]));
        for (UserIdentity userIdentity : managers) {
            JCRProjectMember member = this._getOrCreateJCRProjectMember(project, userIdentity);
            Set<String> allowedProfiles = Set.of(profileId);
            for (WorkspaceModule module : this._projectManager.getModules(project)) {
                this.setProfileOnModule(member, project, module, allowedProfiles);
            }
        }
        project.saveChanges();
        this._getCache().invalidate((Object)ProjectMemberCacheKey.of(project.getId(), null));
        this._rightManager.clearCaches();
    }

    private void _notifyAclUpdated(UserIdentity userIdentity, AmetysObject aclContext, Collection<String> aclProfiles) {
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("acl-context", aclContext);
        eventParams.put("acl-context-identifier", aclContext.getId());
        eventParams.put("acl-profiles", aclProfiles);
        eventParams.put("acl-solr-cache-uninfluential", true);
        this._observationManager.notify(new Event("acl.update", userIdentity, eventParams));
    }

    private JCRProjectMember _getOrCreateJCRProjectMember(Project project, UserIdentity userIdentity) {
        Predicate<AmetysObject> findMemberPredicate = memberNode -> JCRProjectMember.MemberType.USER == ((JCRProjectMember)((Object)memberNode)).getType() && userIdentity.equals((Object)((JCRProjectMember)((Object)memberNode)).getUser());
        JCRProjectMember projectMember = this._getOrCreateJCRProjectMember(project, findMemberPredicate);
        if (projectMember.needsSave()) {
            projectMember.setUser(userIdentity);
            projectMember.setType(JCRProjectMember.MemberType.USER);
        }
        return projectMember;
    }

    private JCRProjectMember _getOrCreateJCRProjectMember(Project project, GroupIdentity groupIdentity) {
        Predicate<AmetysObject> findMemberPredicate = memberNode -> JCRProjectMember.MemberType.GROUP == ((JCRProjectMember)((Object)memberNode)).getType() && groupIdentity.equals((Object)((JCRProjectMember)((Object)memberNode)).getGroup());
        JCRProjectMember projectMember = this._getOrCreateJCRProjectMember(project, findMemberPredicate);
        if (projectMember.needsSave()) {
            projectMember.setGroup(groupIdentity);
            projectMember.setType(JCRProjectMember.MemberType.GROUP);
        }
        return projectMember;
    }

    protected JCRProjectMember _getOrCreateJCRProjectMember(Project project, Predicate<? super AmetysObject> findMemberPredicate) {
        ModifiableTraversableAmetysObject membersNode = this._getProjectMembersNode(project);
        Optional<? super AmetysObject> member = this._getProjectMembersNode(project).getChildren().stream().filter(memberNode -> memberNode instanceof JCRProjectMember).filter(findMemberPredicate).findFirst();
        if (member.isPresent()) {
            return (JCRProjectMember)member.get();
        }
        String baseName = "member";
        Object name = baseName;
        int index = 1;
        while (membersNode.hasChild((String)name)) {
            name = baseName + "-" + ++index;
        }
        JCRProjectMember jcrProjectMember = (JCRProjectMember)membersNode.createChild((String)name, __PROJECT_MEMBER_NODE_TYPE);
        this._getCache().invalidate((Object)ProjectMemberCacheKey.of(project.getId(), null));
        return jcrProjectMember;
    }

    @Callable(rights={""})
    public Map<String, Object> removeMember(String projectName, String identity, String type) {
        Project project = this._projectManager.getProject(projectName);
        if (!this._projectRightHelper.canRemoveMember(project)) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to remove member without convenient right [" + projectName + ", " + identity + "]");
        }
        return this._removeMember(projectName, identity, type, true);
    }

    private Map<String, Object> _removeMember(String projectName, String identity, String type, boolean checkCurrentUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        JCRProjectMember.MemberType memberType = JCRProjectMember.MemberType.valueOf(type.toUpperCase());
        boolean isTypeUser = JCRProjectMember.MemberType.USER == memberType;
        boolean isTypeGroup = JCRProjectMember.MemberType.GROUP == memberType;
        UserIdentity user = Optional.ofNullable(identity).filter(id -> id != null && isTypeUser).map(UserIdentity::stringToUserIdentity).orElse(null);
        GroupIdentity group = Optional.ofNullable(identity).filter(id -> id != null && isTypeGroup).map(GroupIdentity::stringToGroupIdentity).orElse(null);
        if (isTypeGroup && group == null || isTypeUser && user == null) {
            result.put("success", false);
            result.put("message", isTypeGroup ? "unknown-group" : "unknown-user");
            return result;
        }
        Project project = this._projectManager.getProject(projectName);
        if (project == null) {
            result.put("success", false);
            result.put("message", "unknown-project");
            return result;
        }
        if (checkCurrentUser && this._isCurrentUser(isTypeUser, user)) {
            result.put("success", false);
            result.put("message", "current-user");
            return result;
        }
        if (isTypeUser && this.isOnlyManager(project, user)) {
            result.put("success", false);
            result.put("message", "only-manager");
            return result;
        }
        JCRProjectMember projectMember = null;
        if (isTypeUser) {
            projectMember = this._getProjectMember(project, user);
        } else if (isTypeGroup) {
            projectMember = this._getProjectMember(project, group);
        }
        if (projectMember == null) {
            result.put("success", false);
            result.put("message", "unknown-member");
            return result;
        }
        this._removeMember(projectMember, project);
        result.put("success", true);
        return result;
    }

    private void _removeMember(JCRProjectMember projectMember, Project project) {
        this._removeManager(project, projectMember);
        this._removeMemberProfiles(project, projectMember);
        JCRProjectMember.MemberType memberType = projectMember.getType();
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("project.member.identity", JCRProjectMember.MemberType.USER.equals((Object)memberType) ? UserIdentity.userIdentityToString((UserIdentity)projectMember.getUser()) : GroupIdentity.groupIdentityToString((GroupIdentity)projectMember.getGroup()));
        eventParams.put("project.member.identity.type", (Object)memberType);
        eventParams.put("project", (Object)project);
        eventParams.put("projectId", project.getId());
        projectMember.remove();
        project.saveChanges();
        this._getCache().invalidate((Object)ProjectMemberCacheKey.of(project.getId(), null));
        this._observationManager.notify(new Event("member.deleted", this._currentUserProvider.getUser(), eventParams));
    }

    private boolean _isCurrentUser(boolean isTypeUser, UserIdentity user) {
        return isTypeUser && this._currentUserProvider.getUser().equals((Object)user);
    }

    public boolean isOnlyManager(Project project, UserIdentity user) {
        UserIdentity[] managers = project.getManagers();
        return managers.length == 1 && managers[0].equals((Object)user);
    }

    private JCRProjectMember _getProjectMember(Project project, GroupIdentity group) {
        JCRProjectMember projectMember = null;
        ModifiableTraversableAmetysObject membersNode = this._getProjectMembersNode(project);
        for (AmetysObject memberNode : membersNode.getChildren()) {
            JCRProjectMember member;
            if (!(memberNode instanceof JCRProjectMember) || JCRProjectMember.MemberType.GROUP != (member = (JCRProjectMember)memberNode).getType() || !group.equals((Object)member.getGroup())) continue;
            projectMember = (JCRProjectMember)memberNode;
        }
        return projectMember;
    }

    private JCRProjectMember _getProjectMember(Project project, UserIdentity user) {
        JCRProjectMember projectMember = null;
        ModifiableTraversableAmetysObject membersNode = this._getProjectMembersNode(project);
        for (AmetysObject memberNode : membersNode.getChildren()) {
            JCRProjectMember member;
            if (!(memberNode instanceof JCRProjectMember) || JCRProjectMember.MemberType.USER != (member = (JCRProjectMember)memberNode).getType() || !user.equals((Object)member.getUser())) continue;
            projectMember = (JCRProjectMember)memberNode;
        }
        return projectMember;
    }

    private void _removeManager(Project project, JCRProjectMember projectMember) {
        if (JCRProjectMember.MemberType.USER.equals((Object)projectMember.getType())) {
            UserIdentity user = projectMember.getUser();
            UserIdentity[] oldManagers = project.getManagers();
            UserIdentity[] managers = (UserIdentity[])Arrays.stream(oldManagers).filter(manager -> !manager.equals((Object)user)).toArray(UserIdentity[]::new);
            project.setManagers(managers);
        }
    }

    private void _removeMemberProfiles(Project project, JCRProjectMember projectMember) {
        for (WorkspaceModule module : this._projectManager.getModules(project)) {
            ModifiableResourceCollection moduleRootNode = module.getModuleRoot(project, false);
            this._removeMemberProfiles(projectMember, (AmetysObject)moduleRootNode);
        }
    }

    protected ModifiableTraversableAmetysObject _getProjectMembersNode(Project project) {
        if (project == null) {
            throw new AmetysRepositoryException("Error getting the project users node, project is null");
        }
        try {
            ModifiableTraversableAmetysObject membersNode = project.hasChild(__PROJECT_MEMBERS_NODE) ? (ModifiableTraversableAmetysObject)project.getChild(__PROJECT_MEMBERS_NODE) : (ModifiableTraversableAmetysObject)project.createChild(__PROJECT_MEMBERS_NODE, __PROJECT_MEMBERS_NODE_TYPE);
            return membersNode;
        }
        catch (AmetysRepositoryException e) {
            throw new AmetysRepositoryException("Error getting the project users node", (Throwable)e);
        }
    }

    protected Map<String, Object> group2Json(Group group) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("id", GroupIdentity.groupIdentityToString((GroupIdentity)group.getIdentity()));
        infos.put("groupId", group.getIdentity().getId());
        infos.put("label", group.getLabel());
        infos.put("sortablename", group.getLabel());
        infos.put("groupDirectory", group.getIdentity().getDirectoryId());
        return infos;
    }

    public Long getMembersCount(Project project) {
        Set<ProjectMember> projectMembers = this.getProjectMembers(project, true);
        return projectMembers.size();
    }

    public List<User> getGroupUsersFromProject(Group group, Project project, BiPredicate<Project, UserIdentity> filteringPredicate) {
        Set projectPopulations = this._populationContextHelper.getUserPopulationsOnContexts(List.of("/sites/" + project.getSite().getName()), false, false);
        return group.getUsers().stream().filter(user -> projectPopulations.contains(user.getPopulationId())).filter(user -> filteringPredicate.test(project, (UserIdentity)user)).map(arg_0 -> ((UserManager)this._userManager).getUser(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Callable(rights={""})
    public Map<String, Object> leaveProject(String projectName) {
        Project project = this._projectManager.getProject(projectName);
        if (!this.isProjectMember(project, this._currentUserProvider.getUser())) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried perform operation without convenient right");
        }
        UserIdentity currentUser = this._currentUserProvider.getUser();
        String identity = UserIdentity.userIdentityToString((UserIdentity)currentUser);
        Map<String, Object> result = this._removeMember(projectName, identity, JCRProjectMember.MemberType.USER.toString(), false);
        return result;
    }

    private Cache<ProjectMemberCacheKey, Set<ProjectMember>> _getCache() {
        return this._abstractCacheManager.get(__PROJECT_MEMBER_CACHE);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public boolean supports(Event event) {
        String eventId = event.getId();
        return "user.deleted".equals(eventId) || "group.deleted".equals(eventId);
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        String query = switch (event.getId()) {
            case "user.deleted" -> {
                UserIdentity userIdentity = (UserIdentity)event.getArguments().get("user");
                yield "//element(*, ametys:project-member)[" + new UserExpression("user", Expression.Operator.EQ, userIdentity).build() + "]";
            }
            case "group.deleted" -> {
                GroupIdentity groupIdentity = (GroupIdentity)event.getArguments().get("group");
                yield "//element(*, ametys:project-member)[group/groupId=" + groupIdentity.getId() + " and group/groupDirectory=" + groupIdentity.getDirectoryId() + "]";
            }
            default -> throw new IllegalStateException("Event id '" + event.getId() + "' is not supported");
        };
        try (AmetysObjectIterable members = this._resolver.query(query);){
            for (JCRProjectMember member : members) {
                AmetysObject parent = member.getParent().getParent();
                if (!(parent instanceof Project)) continue;
                Project project = (Project)parent;
                this._removeMember(member, project);
            }
        }
    }

    public static class ProjectMember {
        private String _title;
        private String _sortableTitle;
        private JCRProjectMember.MemberType _type;
        private String _role;
        private User _user;
        private Group _group;
        private boolean _isManager;

        public ProjectMember(Group group) {
            this._title = group.getLabel();
            this._sortableTitle = group.getLabel();
            this._type = JCRProjectMember.MemberType.GROUP;
            this._role = null;
            this._isManager = false;
            this._user = null;
            this._group = group;
        }

        public ProjectMember(User user, String role, boolean isManager) {
            this._title = user.getFullName();
            this._sortableTitle = user.getSortableName();
            this._type = JCRProjectMember.MemberType.USER;
            this._role = role;
            this._isManager = isManager;
            this._user = user;
            this._group = null;
        }

        public String getTitle() {
            return this._title;
        }

        public String getSortableTitle() {
            return this._sortableTitle;
        }

        public JCRProjectMember.MemberType getType() {
            return this._type;
        }

        public String getRole() {
            return this._role;
        }

        public boolean isManager() {
            return this._isManager;
        }

        public User getUser() {
            return this._user;
        }

        public Group getGroup() {
            return this._group;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ProjectMember)) {
                return false;
            }
            ProjectMember otherMember = (ProjectMember)obj;
            if (this.getType() != otherMember.getType()) {
                return false;
            }
            if (this.getType() == JCRProjectMember.MemberType.USER) {
                return this.getUser().equals((Object)otherMember.getUser());
            }
            return this.getGroup().equals((Object)otherMember.getGroup());
        }

        public int hashCode() {
            return this.getType() == JCRProjectMember.MemberType.USER ? this.getUser().getIdentity().hashCode() : this.getGroup().getIdentity().hashCode();
        }
    }

    private static final class ProjectMemberCacheKey
    extends AbstractCacheKey {
        public ProjectMemberCacheKey(String projectId, Boolean extendGroup) {
            super(new Object[]{projectId, extendGroup});
        }

        public static ProjectMemberCacheKey of(String projectId, Boolean withExpandedGroup) {
            return new ProjectMemberCacheKey(projectId, withExpandedGroup);
        }
    }
}

