/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.members.observers;

import java.util.List;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.userdirectory.UserDirectoryPageHandler;
import org.ametys.plugins.userdirectory.page.UserDirectoryPageResolver;
import org.ametys.plugins.userdirectory.page.UserPage;
import org.ametys.plugins.workspaces.members.observers.AbstractMemberObserver;
import org.ametys.web.cache.pageelement.PageElementCache;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.Zone;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class InvalidateZoneItemCacheOnMemberUpdatedObserver
extends AbstractMemberObserver {
    private PageElementCache _zoneItemCache;
    private UserDirectoryPageHandler _udPageHandler;
    private UserDirectoryPageResolver _udPageResolver;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._zoneItemCache = (PageElementCache)smanager.lookup(PageElementCache.ROLE + "/zoneItem");
        this._udPageHandler = (UserDirectoryPageHandler)smanager.lookup(UserDirectoryPageHandler.ROLE);
        this._udPageResolver = (UserDirectoryPageResolver)smanager.lookup(UserDirectoryPageResolver.ROLE);
    }

    @Override
    protected void _internalObserve(Event event, List<Content> userContents) throws Exception {
        for (Content content : userContents) {
            if (!(content instanceof JCRAmetysObject)) continue;
            Set rootPages = this._udPageHandler.getUserDirectoryRootPages("org.ametys.plugins.workspaces.Content.member");
            for (Page rootPage : rootPages) {
                UserPage userPage = this._udPageResolver.getUserPage(rootPage, content);
                if (userPage == null) continue;
                AmetysObjectIterable zones = userPage.getZones();
                for (Zone zone : zones) {
                    for (ZoneItem zoneItem : zone.getZoneItems()) {
                        if (!zoneItem.getType().equals((Object)ZoneItem.ZoneType.CONTENT)) continue;
                        this._zoneItemCache.removeItem(null, rootPage.getSiteName(), "CONTENT", zoneItem.getId());
                    }
                }
            }
        }
    }
}

