/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.minisite;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.plugins.workspaces.minisite.AbstractConvertMinisiteEventObserver;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.page.Page;
import org.apache.commons.lang3.ArrayUtils;

public class ConvertContentValidatedEvent2MinisitePageEventObserver
extends AbstractConvertMinisiteEventObserver {
    public boolean supports(Event event) {
        return event.getId().equals("content.validated");
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Project project;
        Content content = (Content)event.getArguments().get("content");
        Object[] cTypes = content.getTypes();
        if (ArrayUtils.contains((Object[])cTypes, (Object)"org.ametys.plugins.workspaces.Content.projectArticle") && content instanceof WebContent && (project = this._getProject((WebContent)content)) != null) {
            this._notifyPageUpdate(content, project, event);
        }
    }

    private void _notifyPageUpdate(Content content, Project project, Event event) {
        Collection referencingPages = ((WebContent)content).getReferencingPages();
        for (Page page : referencingPages) {
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            eventParams.put("page", page);
            eventParams.put("project", (Object)project);
            this._observationManager.notify(new Event("minisite.page.updated", event.getIssuer(), eventParams));
        }
    }

    private Project _getProject(WebContent content) {
        List<String> projects = this._projectManager.getProjectsForSite(content.getSiteName());
        if (projects.size() > 0) {
            return this._projectManager.getProject(projects.get(0));
        }
        return null;
    }
}

