/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.preferences;

import java.util.Map;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.plugins.workspaces.members.JCRProjectMember;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.web.userpref.FOUserPreferencesGenerator;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PreferenceServiceGenerator
extends FOUserPreferencesGenerator {
    private ProjectManager _projectManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._projectManager = (ProjectManager)((Object)smanager.lookup(ProjectManager.ROLE));
    }

    protected void _saxPreferences(String storageContext, Map<String, String> contextVars, UserIdentity user, boolean excludePrivate) throws ProcessingException, SAXException, UserPreferencesException {
        super._saxPreferences(storageContext, contextVars, user, excludePrivate);
        this._saxProjects(user);
    }

    private void _saxProjects(UserIdentity user) throws SAXException {
        Map<Project, JCRProjectMember.MemberType> userProjects = this._projectManager.getUserProjects(user);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"userProjects");
        for (Map.Entry<Project, JCRProjectMember.MemberType> entry : userProjects.entrySet()) {
            Project project = entry.getKey();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", project.getId());
            attrs.addCDATAAttribute("name", project.getName());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"project", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)project.getTitle());
            String description = project.getDescription();
            if (description != null) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"description", (String)description);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"project");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"userProjects");
    }
}

