/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.core.group.GroupDirectoryContextHelper;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.core.util.language.UserLanguagesManager;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.plugins.workspaces.WorkspacesHelper;
import org.ametys.plugins.workspaces.about.AboutWorkspaceModule;
import org.ametys.plugins.workspaces.alert.AlertWorkspaceModule;
import org.ametys.plugins.workspaces.categories.Category;
import org.ametys.plugins.workspaces.categories.CategoryHelper;
import org.ametys.plugins.workspaces.categories.CategoryProviderExtensionPoint;
import org.ametys.plugins.workspaces.keywords.KeywordProviderExtensionPoint;
import org.ametys.plugins.workspaces.keywords.KeywordsDAO;
import org.ametys.plugins.workspaces.members.JCRProjectMember;
import org.ametys.plugins.workspaces.members.MembersWorkspaceModule;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.news.NewsWorkspaceModule;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.favorites.FavoritesHelper;
import org.ametys.plugins.workspaces.project.notification.preferences.NotificationPreferencesHelper;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.project.rights.ProjectRightHelper;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteDAO;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.tika.io.FilenameUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ProjectsCatalogueManager
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = ProjectsCatalogueManager.class.getName();
    public static final Set<String> DEFAULT_MODULES = Set.of(MembersWorkspaceModule.MEMBERS_MODULE_ID, AboutWorkspaceModule.ABOUT_MODULE_ID, NewsWorkspaceModule.NEWS_MODULE_ID, AlertWorkspaceModule.ALERT_MODULE_ID);
    private static final String[] __ALLOWED_FORM_DATA = new String[]{"description", "emailList", "inscriptionStatus", "defaultProfile", "tags", "categoryTags", "keywords"};
    protected AmetysObjectResolver _resolver;
    protected CurrentUserProvider _currentUserProvider;
    protected ProjectMemberManager _projectMemberManager;
    protected RightManager _rightManager;
    protected ProjectManager _projectManager;
    protected SourceResolver _sourceResolver;
    protected SiteDAO _siteDAO;
    protected PopulationContextHelper _populationContextHelper;
    protected UserManager _userManager;
    protected I18nUtils _i18nUtils;
    protected ObservationManager _observationManager;
    protected GroupDirectoryContextHelper _groupDirectoryContextHelper;
    protected CategoryProviderExtensionPoint _categoryProviderEP;
    protected KeywordProviderExtensionPoint _keywordProviderEP;
    protected FavoritesHelper _favoritesHelper;
    protected NotificationPreferencesHelper _notificationPreferenceHelper;
    protected UserLanguagesManager _userLanguagesManager;
    protected ProjectRightHelper _projectRightsHelper;
    protected WorkspacesHelper _workspacesHelper;
    private CategoryHelper _categoryHelper;
    private UserHelper _userHelper;
    private KeywordsDAO _keywordsDAO;

    public void service(ServiceManager manager) throws ServiceException {
        this._userHelper = (UserHelper)manager.lookup(UserHelper.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._projectMemberManager = (ProjectMemberManager)((Object)manager.lookup(ProjectMemberManager.ROLE));
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._siteDAO = (SiteDAO)manager.lookup(SiteDAO.ROLE);
        this._populationContextHelper = (PopulationContextHelper)manager.lookup(PopulationContextHelper.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._groupDirectoryContextHelper = (GroupDirectoryContextHelper)manager.lookup(GroupDirectoryContextHelper.ROLE);
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)manager.lookup(CategoryProviderExtensionPoint.ROLE));
        this._keywordProviderEP = (KeywordProviderExtensionPoint)((Object)manager.lookup(KeywordProviderExtensionPoint.ROLE));
        this._workspacesHelper = (WorkspacesHelper)((Object)manager.lookup(WorkspacesHelper.ROLE));
        this._categoryHelper = (CategoryHelper)manager.lookup(CategoryHelper.ROLE);
        this._keywordsDAO = (KeywordsDAO)((Object)manager.lookup(KeywordsDAO.ROLE));
        this._favoritesHelper = (FavoritesHelper)((Object)manager.lookup(FavoritesHelper.ROLE));
        this._notificationPreferenceHelper = (NotificationPreferencesHelper)((Object)manager.lookup(NotificationPreferencesHelper.ROLE));
        this._userLanguagesManager = (UserLanguagesManager)manager.lookup(UserLanguagesManager.ROLE);
        this._projectRightsHelper = (ProjectRightHelper)((Object)manager.lookup(ProjectRightHelper.ROLE));
    }

    private Pair<List<String>, List<Map<String, Object>>> _createMissingKeywords(List<Object> keywords, ZoneItem zoneItem) {
        List newKeywordsInfo = Collections.emptyList();
        String[] keywordsToCreate = (String[])keywords.stream().filter(t -> t instanceof Map).map(t -> (String)((Map)t).get("text")).toArray(String[]::new);
        if (keywordsToCreate.length > 0) {
            boolean hasRight;
            boolean hasCatalogReadAccess = this._projectRightsHelper.hasCatalogReadAccess(zoneItem);
            SitemapElement catalogPage = zoneItem.getZone().getSitemapElement();
            boolean bl = hasRight = hasCatalogReadAccess && (this._rightManager.currentUserHasRight("Workspace_Rights_Keywords_HandleKeyword", (Object)catalogPage) == RightManager.RightResult.RIGHT_ALLOW || this._rightManager.currentUserHasRight("Workspace_Rights_Keywords_HandleKeyword", (Object)"/cms") == RightManager.RightResult.RIGHT_ALLOW);
            if (!hasRight) {
                throw new AccessDeniedException("User " + String.valueOf(this._currentUserProvider.getUser()) + " tried to create a project tag without the convinient rights");
            }
            newKeywordsInfo = this._keywordsDAO.addTags(keywordsToCreate);
        }
        Iterator newKeywordsInfoIterator = newKeywordsInfo.iterator();
        List keywordsToSet = keywords.stream().map(t -> t instanceof String ? (String)t : (String)((Map)newKeywordsInfoIterator.next()).get("name")).collect(Collectors.toList());
        return Pair.of(keywordsToSet, newKeywordsInfo);
    }

    @Callable(rights={""})
    public Map<String, Object> createProject(String zoneItemId, String title, String description, Object illustration, String category, List<Object> keywords, Integer visibility, String defaultProfile, String language, List<String> managers, List<String> modules) {
        ZoneItem zoneItem = (ZoneItem)this._resolver.resolveById(zoneItemId);
        Project.InscriptionStatus inscriptionStatus = visibility == 1 ? Project.InscriptionStatus.PRIVATE : (visibility == 2 ? Project.InscriptionStatus.MODERATED : Project.InscriptionStatus.OPEN);
        this._projectManager.checkRightsForProjectCreation(inscriptionStatus, zoneItem);
        Site catalogSite = zoneItem.getZone().getSitemapElement().getSite();
        ModelAwareDataHolder serviceDataHolder = zoneItem.getServiceParameters();
        String titlePrefix = (String)serviceDataHolder.getValue("titlePrefix", false, (Object)"");
        String urlPrefix = (String)catalogSite.getValue("urlPrefix", false, (Object)"");
        String[] availableLanguages = (String[])serviceDataHolder.getValue("availableLanguages");
        String skin = (String)catalogSite.getValue("defaultProjectSkin", false, (Object)"");
        String forceAcceptCookie = (String)serviceDataHolder.getValue("force_accept_cookies", false, (Object)"");
        String[] populationIds = serviceDataHolder.getValue("populationIds") != null ? (String[])serviceDataHolder.getValue("populationIds") : new String[]{};
        if (Arrays.stream(availableLanguages).filter(language::equals).findFirst().isEmpty()) {
            throw new IllegalArgumentException("Cannot create project with language '" + language + "' since it is not part of the available languages " + String.valueOf(availableLanguages));
        }
        String defaultManagerProfile = (String)Config.getInstance().getValue("workspaces.profile.managerdefault", false, null);
        if (StringUtils.isBlank((CharSequence)defaultManagerProfile)) {
            throw new IllegalArgumentException("The general configuration parameter 'workspaces.profile.managerdefault' cannot be empty");
        }
        Pair<List<String>, List<Map<String, Object>>> keywordsInfo = this._createMissingKeywords(keywords, zoneItem);
        List keywordsToSet = (List)keywordsInfo.getLeft();
        List newKeywordsInfo = (List)keywordsInfo.getRight();
        HashMap<String, Object> additionalValues = new HashMap<String, Object>();
        additionalValues.put("description", StringUtils.defaultString((String)description));
        additionalValues.put("categoryTags", Collections.singletonList(category));
        additionalValues.put("inscriptionStatus", inscriptionStatus.toString());
        additionalValues.put("defaultProfile", defaultProfile);
        additionalValues.put("keywords", keywordsToSet);
        additionalValues.put("language", language);
        ArrayList<String> errors = new ArrayList<String>();
        String prefixedTitle = (titlePrefix + " " + title).trim();
        Project project = this._projectManager.createProject(this._findName(prefixedTitle), prefixedTitle, additionalValues, this._withDefaultModules(modules), errors);
        if (!CollectionUtils.isEmpty(errors)) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("success", false);
            return result;
        }
        this._updateSiteInfos(project, urlPrefix, skin, forceAcceptCookie, catalogSite, illustration, language);
        this._assignPopulations(project, catalogSite, Set.of(populationIds));
        this._assignManagers(project, managers, defaultManagerProfile);
        project.saveChanges();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("project", this._detailedMyProject2json(project, zoneItem.getZone().getSitemapElement(), false, this._notificationPreferenceHelper.getPausedProjects(this._currentUserProvider.getUser()) == null ? null : Boolean.valueOf(false)));
        result.put("keywords", newKeywordsInfo);
        return result;
    }

    private void _assignPopulations(Project project, Site catalogSite, Set<String> serviceParameterPopulationIds) {
        Site site = project.getSite();
        Set populations = this._populationContextHelper.getUserPopulationsOnContext("/sites/" + catalogSite.getName(), false);
        Set frontPopulations = this._populationContextHelper.getUserPopulationsOnContext("/sites-fo/" + catalogSite.getName(), false);
        if (serviceParameterPopulationIds.size() > 0) {
            populations = populations.stream().filter(populationId -> serviceParameterPopulationIds.contains(populationId)).collect(Collectors.toSet());
            frontPopulations = frontPopulations.stream().filter(populationId -> serviceParameterPopulationIds.contains(populationId)).collect(Collectors.toSet());
        }
        this._populationContextHelper.link("/sites/" + site.getName(), (Collection)populations);
        this._populationContextHelper.link("/sites-fo/" + site.getName(), (Collection)frontPopulations);
        Set groupDirectories = this._groupDirectoryContextHelper.getGroupDirectoriesOnContext("/sites/" + catalogSite.getName());
        Set frontGroupDirectories = this._groupDirectoryContextHelper.getGroupDirectoriesOnContext("/sites-fo/" + catalogSite.getName());
        this._groupDirectoryContextHelper.link("/sites/" + site.getName(), new ArrayList(groupDirectories));
        this._groupDirectoryContextHelper.link("/sites-fo/" + site.getName(), new ArrayList(frontGroupDirectories));
    }

    private void _assignManagers(Project project, List<String> managers, String defaultManagerProfile) {
        List<UserIdentity> projectManagers = managers.stream().map(UserIdentity::stringToUserIdentity).filter(Objects::nonNull).filter(user -> this._projectManager.isUserInProjectPopulations(project, (UserIdentity)user)).collect(Collectors.toList());
        this._projectMemberManager.setProjectManager(project.getName(), defaultManagerProfile, projectManagers);
    }

    private void _updateSiteInfos(Project project, String urlPrefix, String skin, String forceAcceptCookie, Site catalogSite, Object illustration, String language) {
        Site site = project.getSite();
        site.setUrl(urlPrefix + "/" + project.getName());
        site.setValue("skin", (Object)skin);
        if (site.hasDefinition("force-accept-cookies")) {
            site.setValue("force-accept-cookies", (Object)forceAcceptCookie);
        }
        site.setValue("display-restricted-pages", (Object)false);
        site.setValue("ping_activated", (Object)false);
        site.setValue("site-mail-from", catalogSite.getValue("site-mail-from"));
        site.setValue("site-contents-comments-postvalidation", catalogSite.getValue("site-contents-comments-postvalidation"));
        site.setValue("color", catalogSite.getValue("color"));
        this._setIllustration(site, illustration);
        this._siteDAO.setLanguages(site, Collections.singletonList(language));
        site.saveChanges();
        HashMap<String, Site> eventParams = new HashMap<String, Site>();
        eventParams = new HashMap();
        eventParams.put("site", site);
        this._observationManager.notify(new Event("site.updated", this._currentUserProvider.getUser(), eventParams));
    }

    private void _setIllustration(Site site, Object illustration) {
        block19: {
            Object illustrationObject = null;
            try {
                illustrationObject = this._getIllustrationSource(illustration);
                if (illustrationObject instanceof Source) {
                    Source illustrationSource = (Source)illustrationObject;
                    try (InputStream is = illustrationSource.getInputStream();){
                        site.setIllustration(is, illustrationSource.getMimeType(), FilenameUtils.getName((String)illustrationSource.getURI()), ZonedDateTime.now());
                        break block19;
                    }
                }
                if (!(illustrationObject instanceof Part)) break block19;
                Part illustrationPart = (Part)illustrationObject;
                try (InputStream is = illustrationPart.getInputStream();){
                    site.setIllustration(is, illustrationPart.getMimeType(), illustrationPart.getUploadName(), ZonedDateTime.now());
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot not get illustration", e);
            }
            finally {
                if (illustrationObject instanceof Source) {
                    this._sourceResolver.release((Source)illustrationObject);
                }
            }
        }
    }

    private Object _getIllustrationSource(Object illustration) throws IOException {
        if (illustration instanceof String) {
            String illustrationAsString = (String)illustration;
            if (illustrationAsString.contains("/") || illustrationAsString.contains("\\")) {
                throw new IllegalArgumentException("Cannot choose an illustration outside the library directory");
            }
            return this._sourceResolver.resolveURI("plugin:workspaces://resources/img/catalog/library/" + illustrationAsString);
        }
        if (illustration instanceof Part) {
            Part illustrationAsFile = (Part)illustration;
            return illustrationAsFile;
        }
        return null;
    }

    private Set<String> _withDefaultModules(List<String> modules) {
        HashSet<String> modulesToActivate = new HashSet<String>();
        modulesToActivate.addAll(DEFAULT_MODULES);
        modulesToActivate.addAll(modules);
        return modulesToActivate;
    }

    private String _findName(String title) {
        String originalName = NameHelper.filterName((String)title);
        Object name = originalName;
        int index = 2;
        while (this._projectManager.hasProject((String)name)) {
            name = originalName + "-" + index++;
        }
        return name;
    }

    @Callable(rights={""})
    public Map<String, Object> editProject(String zoneItemId, String projectId, String title, String description, Object illustration, String category, List<Object> keywords, Integer visibility, String defaultProfile, List<String> managers, List<String> modules) {
        HashMap<String, Object> eventParams;
        boolean canEdit;
        Project project = (Project)this._resolver.resolveById(projectId);
        if (project == null) {
            throw new IllegalArgumentException("Unable to edit a project, invalid project id received '" + projectId + "'");
        }
        ZoneItem zoneItem = (ZoneItem)this._resolver.resolveById(zoneItemId);
        Project.InscriptionStatus inscriptionStatus = visibility == 1 ? Project.InscriptionStatus.PRIVATE : (visibility == 2 ? Project.InscriptionStatus.MODERATED : Project.InscriptionStatus.OPEN);
        this._projectManager.checkRightsForProjectEdition(project, inscriptionStatus, zoneItem);
        String defaultManagerProfile = (String)Config.getInstance().getValue("workspaces.profile.managerdefault", false, null);
        if (StringUtils.isBlank((CharSequence)defaultManagerProfile)) {
            throw new IllegalArgumentException("The general configuration parameter 'workspaces.profile.managerdefault' cannot be empty");
        }
        boolean bl = canEdit = this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Edit", (Object)project) == RightManager.RightResult.RIGHT_ALLOW || this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Edit", (Object)zoneItem.getZone().getSitemapElement()) == RightManager.RightResult.RIGHT_ALLOW;
        if (!canEdit) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to edit the project '" + projectId + "' without sufficient rights");
        }
        Pair<List<String>, List<Map<String, Object>>> keywordsInfo = this._createMissingKeywords(keywords, zoneItem);
        List keywordsToSet = (List)keywordsInfo.getLeft();
        List newKeywordsInfo = (List)keywordsInfo.getRight();
        project.setTitle(title);
        project.setDescription(StringUtils.defaultString((String)description));
        project.setInscriptionStatus(inscriptionStatus.toString());
        project.setDefaultProfile(defaultProfile);
        project.setCategoryTags(Collections.singletonList(category));
        project.setKeywords(keywordsToSet.toArray(new String[keywordsToSet.size()]));
        Site site = project.getSite();
        this._projectManager.setProjectSiteTitle(site, project.getTitle());
        this._setIllustration(site, illustration);
        if (site.needsSave()) {
            site.saveChanges();
            eventParams = new HashMap<String, Object>();
            eventParams.put("site", site);
            this._observationManager.notify(new Event("site.updated", this._currentUserProvider.getUser(), eventParams));
        }
        this._updateModules(project, this._withDefaultModules(modules));
        this._assignManagers(project, managers, defaultManagerProfile);
        if (project.needsSave()) {
            project.saveChanges();
        }
        eventParams = new HashMap();
        eventParams.put("project", (Object)project);
        eventParams.put("projectId", project.getId());
        this._observationManager.notify(new Event("project.updated", this._currentUserProvider.getUser(), eventParams));
        UserIdentity user = this._currentUserProvider.getUser();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("project", this._detailedMyProject2json(project, zoneItem.getZone().getSitemapElement(), this._favoritesHelper.getFavorites(user).contains(project.getName()), this._notificationPreferenceHelper.getPausedProjects(user).contains(project.getName())));
        result.put("keywords", newKeywordsInfo);
        return result;
    }

    private void _updateModules(Project project, Set<String> modules) {
        HashSet<String> modulesToActivate = new HashSet<String>(modules);
        HashSet<String> modulesToDeactivate = new HashSet<String>(Arrays.asList(project.getModules()));
        modulesToActivate.removeAll(new HashSet<String>(Arrays.asList(project.getModules())));
        modulesToDeactivate.removeAll(modules);
        if (!modulesToActivate.isEmpty()) {
            HashMap<String, Object> additionalValues = new HashMap<String, Object>();
            additionalValues.put("description", project.getDescription());
            additionalValues.put("inscriptionStatus", (Object)project.getInscriptionStatus());
            additionalValues.put("emailList", project.getMailingList());
            additionalValues.put("defaultProfile", project.getDefaultProfile());
            additionalValues.put("categoryTags", project.getCategories());
            additionalValues.put("keywords", project.getKeywords());
            Site site = project.getSite();
            if (site != null) {
                additionalValues.put("language", ((Sitemap)site.getSitemaps().iterator().next()).getName());
            }
            this._projectManager.activateModules(project, modulesToActivate, additionalValues);
        }
        if (!modulesToDeactivate.isEmpty()) {
            this._projectManager.deactivateModules(project, modulesToDeactivate);
        }
    }

    @Callable(rights={""})
    public Map<String, Object> deleteProject(String zoneItemId, String projectId) {
        boolean canDelete;
        Project project = (Project)this._resolver.resolveById(projectId);
        if (project == null) {
            throw new IllegalArgumentException("Unable to delete a project, invalid project id received '" + projectId + "'");
        }
        ZoneItem zoneItem = (ZoneItem)this._resolver.resolveById(zoneItemId);
        boolean bl = canDelete = this._projectRightsHelper.hasCatalogReadAccess(zoneItem) && (this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Delete", (Object)project) == RightManager.RightResult.RIGHT_ALLOW || this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Delete", (Object)zoneItem.getZone().getSitemapElement()) == RightManager.RightResult.RIGHT_ALLOW);
        if (!canDelete) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to delete the project '" + projectId + "' without sufficient rights");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("sites", this._projectManager.deleteProject(project));
        result.put("success", true);
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> joinProject(String projectId) throws MessagingException, IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = (Project)this._resolver.resolveById(projectId);
        if (project == null) {
            throw new IllegalArgumentException("Unable to join a project, invalid project id received '" + projectId + "'");
        }
        UserIdentity currentUser = this._currentUserProvider.getUser();
        Site site = project.getSite();
        try {
            if (!this._projectManager.isUserInProjectPopulations(project, currentUser)) {
                result.put("success", false);
                return result;
            }
        }
        catch (IllegalArgumentException e) {
            result.put("success", false);
            return result;
        }
        JCRProjectMember addedMember = this._projectMemberManager.addProjectMember(project, currentUser);
        boolean success = addedMember != null;
        result.put("success", success);
        if (success) {
            String url = site.getUrl();
            result.put("url", url);
            String mailFrom = (String)Config.getInstance().getValue("smtp.mail.from");
            if (mailFrom != null) {
                HashMap<String, I18nizableText> params = new HashMap<String, I18nizableText>();
                User current = this._userManager.getUser(currentUser);
                params.put("user", new I18nizableText(current != null ? current.getFullName() : currentUser.getLogin()));
                params.put("project", new I18nizableText(project.getTitle()));
                params.put("url", new I18nizableText(url != null ? url : ""));
                I18nizableText i18nSubject = new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_MAIL_TITLE", params);
                I18nizableText i18nTextBody = new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_MAIL_BODY_TEXT", params);
                StandardMailBodyHelper.MailBodyBuilder htmlBodyBuilder = StandardMailBodyHelper.newHTMLBody().withTitle(i18nSubject).withMessage(new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_MAIL_BODY_HTML", params)).withLink(url, new I18nizableText("plugin.workspaces", "PROJECT_MAIL_NOTIFICATION_BODY_DEFAULT_BUTTON_TEXT"));
                this._sendMailToManagers(project, mailFrom, i18nSubject, htmlBodyBuilder, i18nTextBody);
            }
        }
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> askToJoinProject(String projectId, String message) throws MessagingException, IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = (Project)this._resolver.resolveById(projectId);
        if (project == null) {
            throw new IllegalArgumentException("Unable to join a project, invalid project id received '" + projectId + "'");
        }
        UserIdentity currentUser = this._currentUserProvider.getUser();
        if (!this._projectManager.isUserInProjectPopulations(project, currentUser)) {
            result.put("success", false);
            return result;
        }
        this._sendAskToJoinMail(message, project, currentUser);
        result.put("success", true);
        result.put("added-notification", Config.getInstance().getValue("workspaces.member.added.send.notification"));
        return result;
    }

    private void _sendAskToJoinMail(String message, Project project, UserIdentity joiningUser) throws MessagingException, IOException {
        String url = this.getAddUserUrl(project, joiningUser);
        String mailFrom = (String)Config.getInstance().getValue("smtp.mail.from");
        if (mailFrom != null) {
            HashMap<String, I18nizableText> params = new HashMap<String, I18nizableText>();
            User current = this._userManager.getUser(joiningUser);
            params.put("user", new I18nizableText(current != null ? current.getFullName() : joiningUser.getLogin()));
            params.put("project", new I18nizableText(project.getTitle()));
            params.put("url", new I18nizableText(url));
            I18nizableText i18nSubject = new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_ASK_MAIL_SUBJECT", params);
            StandardMailBodyHelper.MailBodyBuilder bodyBuilder = StandardMailBodyHelper.newHTMLBody().withTitle(new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_ASK_MAIL_BODY_TITLE", params)).withMessage(new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_ASK_MAIL_BODY", params)).withLink(url, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_ASK_MAIL_ADD_USER_LINK"));
            if (!StringUtils.isEmpty((CharSequence)message)) {
                bodyBuilder.withDetails(new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_ASK_MAIL_BODY_MSG"), message, false);
            }
            this._sendMailToManagers(project, mailFrom, i18nSubject, bodyBuilder, null);
        }
    }

    private void _sendMailToManagers(Project project, String mailFrom, I18nizableText i18nSubject, StandardMailBodyHelper.MailBodyBuilder bodyBuilder, I18nizableText i18nTextBody) throws MessagingException, IOException {
        String defaultLanguage = this._workspacesHelper.getLang(project, this._userLanguagesManager.getDefaultLanguage());
        Map managersToNotifyByLanguage = Arrays.stream(project.getManagers()).map(manager -> this._userManager.getUser(manager)).filter(Objects::nonNull).map(user -> Pair.of((Object)user, (Object)user.getEmail())).filter(p -> StringUtils.isNotEmpty((CharSequence)((CharSequence)p.getRight()))).collect(Collectors.groupingBy(p -> (String)StringUtils.defaultIfBlank((CharSequence)((User)p.getLeft()).getLanguage(), (CharSequence)defaultLanguage), Collectors.mapping(Pair::getRight, Collectors.toList())));
        for (String lang : managersToNotifyByLanguage.keySet()) {
            String subject = this._i18nUtils.translate((I18nizable)i18nSubject, lang);
            String htmlBody = bodyBuilder.withLanguage(lang).build();
            SendMailHelper.MailBuilder mail = SendMailHelper.newMail().withSubject(subject).withHTMLBody(htmlBody).withSender(mailFrom).withRecipients(managersToNotifyByLanguage.get(lang));
            if (i18nTextBody != null) {
                String textBody = this._i18nUtils.translate((I18nizable)i18nTextBody, lang);
                mail.withTextBody(textBody);
            }
            mail.sendMail();
        }
    }

    protected String getAddUserUrl(Project project, UserIdentity user) {
        Site site;
        String siteURL;
        String urlWithoutScheme;
        String memberPage = "";
        Set<Page> membersPages = this._projectManager.getModulePages(project, MembersWorkspaceModule.MEMBERS_MODULE_ID);
        if (!membersPages.isEmpty()) {
            memberPage = ResolveURIComponent.resolve((String)"page", (String)membersPages.iterator().next().getId(), (boolean)false, (boolean)true);
        }
        String relativeURL = StringUtils.contains((CharSequence)(urlWithoutScheme = StringUtils.substringAfter((String)(siteURL = (site = project.getSite()).getUrl()), (String)"://")), (CharSequence)"/") ? "/" + StringUtils.substringAfter((String)urlWithoutScheme, (String)"/") : "";
        return siteURL + "/_authenticate?requestedURL=" + URIUtils.encodeParameter((String)(relativeURL + "/plugins/workspaces/add-member?redirect=" + URIUtils.encodeParameter((String)(memberPage + "?added=" + URIUtils.encodeParameter((String)UserIdentity.userIdentityToString((UserIdentity)user)))) + "&user=" + URIUtils.encodeParameter((String)UserIdentity.userIdentityToString((UserIdentity)user)) + "&project=" + URIUtils.encodeParameter((String)project.getName())));
    }

    protected String[] getAllowedFormData() {
        return __ALLOWED_FORM_DATA;
    }

    @Callable(rights={""})
    public Map<String, Object> getUserAndPublicProjects(String zoneItemId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ZoneItem zoneItem = (ZoneItem)this._resolver.resolveById(zoneItemId);
        if (!this._projectRightsHelper.hasCatalogReadAccess(zoneItem)) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to do read operation without convenient right");
        }
        ModelAwareDataHolder serviceDataHolder = zoneItem.getServiceParameters();
        String[] populationIds = serviceDataHolder.getValue("populationIds") != null ? (String[])serviceDataHolder.getValue("populationIds") : new String[]{};
        UserIdentity user = this._currentUserProvider.getUser();
        boolean inPopulation = populationIds.length == 0 || Arrays.asList(populationIds).contains(user.getPopulationId());
        SitemapElement sitemapElement = zoneItem.getZone().getSitemapElement();
        boolean canCreatePrivateProjet = inPopulation && (this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Create_Private", (Object)"/cms") == RightManager.RightResult.RIGHT_ALLOW || this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Create_Private", (Object)sitemapElement) == RightManager.RightResult.RIGHT_ALLOW);
        boolean canCreatePublicProjetWithModeration = inPopulation && (this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Create_Public_Moderated", (Object)"/cms") == RightManager.RightResult.RIGHT_ALLOW || this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Create_Public_Moderated", (Object)sitemapElement) == RightManager.RightResult.RIGHT_ALLOW);
        boolean canCreatePublicProjet = inPopulation && (this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Create_Public_Opened", (Object)"/cms") == RightManager.RightResult.RIGHT_ALLOW || this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Create_Public_Opened", (Object)sitemapElement) == RightManager.RightResult.RIGHT_ALLOW);
        result.put("canCreate", canCreatePrivateProjet || canCreatePublicProjetWithModeration || canCreatePublicProjet);
        result.put("canCreatePrivateProject", canCreatePrivateProjet);
        result.put("canCreatePublicProjectWithModeration", canCreatePublicProjetWithModeration);
        result.put("canCreatePublicProject", canCreatePublicProjet);
        ArrayList<Map<String, Object>> userProjects = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> publicProjects = new ArrayList<Map<String, Object>>();
        Set<String> favorites = this._favoritesHelper.getFavorites(user);
        Set<String> pausedProjects = this._notificationPreferenceHelper.getPausedProjects(user);
        for (Project project : this._projectManager.getProjects()) {
            Map<String, Object> json;
            if (this._projectMemberManager.isProjectMember(project, user)) {
                json = this._detailedMyProject2json(project, sitemapElement, favorites.contains(project.getName()), pausedProjects != null ? Boolean.valueOf(pausedProjects.contains(project.getName())) : null);
                userProjects.add(json);
                continue;
            }
            if (project.getInscriptionStatus() == Project.InscriptionStatus.PRIVATE || !this._projectManager.isUserInProjectPopulations(project, user)) continue;
            json = this.detailedProject2json(project);
            publicProjects.add(json);
        }
        result.put("userProjects", userProjects);
        result.put("availablePublicProjects", publicProjects);
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> getProjectByName(String projectName, String zoneItemId) {
        ZoneItem zoneItem = (ZoneItem)this._resolver.resolveById(zoneItemId);
        if (!this._projectRightsHelper.hasCatalogReadAccess(zoneItem)) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to do read operation without convenient right");
        }
        Project project = this._projectManager.getProject(projectName);
        return this.detailedProject2json(project);
    }

    @Callable(rights={""})
    public List<Map<String, Object>> getUserProjects() {
        UserIdentity user = this._currentUserProvider.getUser();
        ArrayList<Map<String, Object>> userProjects = new ArrayList<Map<String, Object>>();
        Set<String> favorites = this._favoritesHelper.getFavorites(user);
        Set<String> pausedProjects = this._notificationPreferenceHelper.getPausedProjects(user);
        for (Project project : this._projectManager.getProjects()) {
            if (!this._projectMemberManager.isProjectMember(project, user)) continue;
            Map<String, Object> json = this._detailedMyProject2json(project, null, favorites.contains(project.getName()), pausedProjects != null ? Boolean.valueOf(pausedProjects.contains(project.getName())) : null);
            userProjects.add(json);
        }
        return userProjects;
    }

    private Map<String, Object> _detailedMyProject2json(Project project, SitemapElement catalogPage, boolean isFavorite, Boolean isPaused) {
        Map<String, Object> json = this.detailedProject2json(project);
        json.put("favorite", isFavorite);
        json.put("notification", isPaused != null ? Boolean.valueOf(isPaused == false) : null);
        boolean canEdit = this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Edit", (Object)project) == RightManager.RightResult.RIGHT_ALLOW || catalogPage != null && this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Edit", (Object)catalogPage) == RightManager.RightResult.RIGHT_ALLOW;
        json.put("canEdit", canEdit);
        boolean canDelete = this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Delete", (Object)project) == RightManager.RightResult.RIGHT_ALLOW || catalogPage != null && this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Delete", (Object)catalogPage) == RightManager.RightResult.RIGHT_ALLOW;
        json.put("canDelete", canDelete);
        json.put("canAccessBO", this._projectManager.canAccessBO(project));
        json.put("canLeaveProject", this._projectManager.canLeaveProject(project));
        return json;
    }

    public Map<String, Object> detailedProject2json(Project project) {
        String c;
        Category category;
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("id", project.getId());
        json.put("name", project.getName());
        json.put("title", project.getTitle());
        json.put("url", this._projectManager.getProjectUrl(project, ""));
        json.put("defaultProfile", project.getDefaultProfile());
        Set<String> categories = project.getCategories();
        if (categories.size() != 1) {
            this.getLogger().warn("Project " + project.getTitle() + " (" + project.getId() + ") should have one and only one category");
        }
        if (!categories.isEmpty() && (category = (Category)this._categoryProviderEP.getTag(c = categories.iterator().next(), new HashMap())) != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", category.getId());
            map.put("name", category.getName());
            map.put("title", (String)category.getTitle());
            map.put("color", this._categoryHelper.getCategoryColor(category).get("main"));
            json.put("category", map);
        }
        String[] keywords = (String[])Stream.of(project.getKeywords()).filter(k -> this._keywordProviderEP.hasTag((String)k, new HashMap())).toArray(String[]::new);
        json.put("keywords", keywords);
        UserIdentity[] managers = project.getManagers();
        if (managers.length > 0) {
            json.put("managers", Arrays.stream(managers).map(arg_0 -> ((UserHelper)this._userHelper).user2json(arg_0)).filter(userAsJson -> !userAsJson.equals(Collections.EMPTY_MAP)).collect(Collectors.toList()));
        }
        ArrayList<Map> members = new ArrayList<Map>();
        for (int i = 1; i < Math.min(managers.length, 4); ++i) {
            members.add(this._userHelper.user2json(managers[i]));
        }
        if (members.size() < 3) {
            List<UserIdentity> managersList = Arrays.asList(managers);
            members.addAll(this._projectMemberManager.getProjectMembers(project, true).stream().map(ProjectMemberManager.ProjectMember::getUser).map(User::getIdentity).filter(Predicate.not(managersList::contains)).limit(3 - members.size()).map(arg_0 -> ((UserHelper)this._userHelper).user2json(arg_0)).collect(Collectors.toList()));
        }
        json.put("members", members);
        json.put("membersCount", this._projectMemberManager.getMembersCount(project));
        json.put("modules", Arrays.asList(project.getModules()));
        switch (project.getInscriptionStatus()) {
            case PRIVATE: {
                json.put("visibility", 1);
                break;
            }
            case MODERATED: {
                json.put("visibility", 2);
                break;
            }
            default: {
                json.put("visibility", 3);
            }
        }
        json.put("description", project.getDescription());
        Site site = project.getSite();
        if (site != null) {
            json.put("site", site.getName());
            json.put("language", ((Sitemap)site.getSitemaps().iterator().next()).getName());
            if (site.getIllustration() != null) {
                String illustration = ResolveURIComponent.resolveCroppedImage((String)"site-parameter", (String)(site.getName() + ";illustration"), (int)252, (int)389, (boolean)false, (boolean)true);
                json.put("illustration", illustration);
            }
        }
        return json;
    }

    public void saxProject(ContentHandler contentHandler, Project project) throws SAXException {
        this.saxProject(contentHandler, project, false, false, 0, false);
    }

    public void saxProject(ContentHandler contentHandler, Project project, boolean withMembers, boolean expandGroup, int maxMembers, boolean isFavorite) throws SAXException {
        Site site;
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", project.getId());
        attrs.addCDATAAttribute("name", project.getName());
        attrs.addCDATAAttribute("favorite", String.valueOf(isFavorite));
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"project", (Attributes)attrs);
        XMLUtils.createElement((ContentHandler)contentHandler, (String)"title", (String)project.getTitle());
        XMLUtils.createElement((ContentHandler)contentHandler, (String)"inscriptionStatus", (String)project.getInscriptionStatus().name());
        String description = project.getDescription();
        if (description != null) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"description", (String)description);
        }
        XMLUtils.createElement((ContentHandler)contentHandler, (String)"url", (String)this._projectManager.getProjectUrl(project, ""));
        this.saxCategory(contentHandler, project);
        for (String keyword : project.getKeywords()) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"keyword", (String)keyword);
        }
        UserIdentity[] managers = project.getManagers();
        if (managers.length > 0) {
            for (UserIdentity userIdentity : managers) {
                this._userHelper.saxUserIdentity(userIdentity, contentHandler, "manager");
            }
        }
        if (withMembers) {
            Set<ProjectMemberManager.ProjectMember> members = this._projectMemberManager.getProjectMembers(project, expandGroup);
            int nbMembers = members.size();
            attrs.clear();
            attrs.addCDATAAttribute("total", String.valueOf(nbMembers));
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"members", (Attributes)attrs);
            int count = 0;
            Iterator<ProjectMemberManager.ProjectMember> it = members.iterator();
            while (it.hasNext() && (maxMembers < 0 || count < maxMembers)) {
                ProjectMemberManager.ProjectMember member = it.next();
                if (member.isManager()) continue;
                this._userHelper.saxUser(member.getUser(), contentHandler, "member");
                ++count;
            }
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"members");
        }
        if ((site = project.getSite()) != null) {
            attrs.clear();
            attrs.addCDATAAttribute("name", site.getName());
            attrs.addCDATAAttribute("language", ((Sitemap)site.getSitemaps().iterator().next()).getName());
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"site", (Attributes)attrs);
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"project");
    }

    public void saxCategory(ContentHandler contentHandler, Project project) throws SAXException {
        this.saxCategory(contentHandler, project, "category");
    }

    public void saxCategory(ContentHandler contentHandler, Project project, String tagName) throws SAXException {
        String c;
        Category category;
        Set<String> categories = project.getCategories();
        if (!categories.isEmpty() && (category = (Category)this._categoryProviderEP.getTag(c = categories.iterator().next(), new HashMap())) != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", category.getId());
            attrs.addCDATAAttribute("name", category.getName());
            attrs.addCDATAAttribute("color", this._categoryHelper.getCategoryColor(category).get("main"));
            XMLUtils.startElement((ContentHandler)contentHandler, (String)tagName, (Attributes)attrs);
            category.getTitle().toSAX(contentHandler);
            XMLUtils.endElement((ContentHandler)contentHandler, (String)tagName);
        }
    }
}

