/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.generators;

import java.io.IOException;
import java.util.Map;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.observation.Event;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.group.GroupHelper;
import org.ametys.plugins.workspaces.members.JCRProjectMember;
import org.ametys.plugins.workspaces.project.generators.AbstractMailNotifierGenerator;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MemberEventMailNotifierGenerator
extends AbstractMailNotifierGenerator {
    private GroupHelper _groupHelper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._groupHelper = (GroupHelper)smanager.lookup(GroupHelper.ROLE);
    }

    @Override
    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        Map parentContextAttr = (Map)this.objectModel.get("parent-context");
        Event event = (Event)parentContextAttr.get("event");
        Project project = (Project)((Object)parentContextAttr.get("project"));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"notification");
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"eventKey", (String)this.getEventIdAsI18nKey(event.getId()));
        this.saxProject(project);
        this._saxMember(event, project);
        this._saxProjectUserIdentity(event.getIssuer(), project, "issuer");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"notification");
        this.contentHandler.endDocument();
    }

    private void _saxMember(Event event, Project project) throws SAXException {
        Map args = event.getArguments();
        JCRProjectMember.MemberType type = (JCRProjectMember.MemberType)((Object)args.get("project.member.identity.type"));
        String identity = (String)args.get("project.member.identity");
        if (JCRProjectMember.MemberType.USER == type) {
            UserIdentity user = UserIdentity.stringToUserIdentity((String)identity);
            this._saxProjectUserIdentity(user, project, "member");
        } else {
            GroupIdentity group = GroupIdentity.stringToGroupIdentity((String)identity);
            this._saxGroupIdentity(group, "member");
        }
    }

    private void _saxGroupIdentity(GroupIdentity group, String tagname) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)tagname);
        this._groupHelper.saxGroupIdentity(group, this.contentHandler);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)tagname);
    }

    @Override
    protected String _getModuleId() {
        return null;
    }
}

