/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.modules;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.util.StatisticColumn;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.sitemap.Sitemap;

public interface WorkspaceModule
extends Comparable<WorkspaceModule> {
    public static final int ORDER_WALLCONTENT = 0;
    public static final int ORDER_NEWS = 5;
    public static final int ORDER_ALERTS = 5;
    public static final int ORDER_MEMBERS = 10;
    public static final int ORDER_DOCUMENTS = 20;
    public static final int ORDER_FORUMS = 30;
    public static final int ORDER_CALENDAR = 40;
    public static final int ORDER_TASKS = 50;
    public static final int ORDER_MINISITE = 60;
    public static final int ORDER_ABOUT = 70;
    public static final String GROUP_HEADER_ELEMENTS_ID = "general$elements";
    public static final String GROUP_HEADER_SIZE_ID = "general$size";
    public static final String GROUP_HEADER_ACTIVATED_ID = "general$activated";
    public static final String GROUP_HEADER_LAST_ACTIVITY_ID = "general$lastActivity";

    public String getId();

    public I18nizableText getModuleTitle();

    public I18nizableText getModuleDescription();

    public String getModuleName();

    public int getOrder();

    public void activateModule(Project var1, Map<String, Object> var2);

    public void initializeSitemap(Project var1, Sitemap var2);

    public void deactivateModule(Project var1);

    public void deleteData(Project var1);

    public Set<String> getAllowedEventTypes();

    public Set<String> getAllEventTypes();

    public ModifiableResourceCollection getModuleRoot(Project var1, boolean var2);

    public String getModuleUrl(Project var1);

    default public boolean isUnactivatedByDefault() {
        return false;
    }

    @Override
    default public int compareTo(WorkspaceModule that) {
        if (this.getOrder() == that.getOrder()) {
            return this.getId().compareTo(that.getId());
        }
        return this.getOrder() - that.getOrder();
    }

    public Map<String, Object> getStatistics(Project var1);

    public List<StatisticColumn> getStatisticModel();

    public String getModuleSizeKey();
}

