/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.observers;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.workspaces.PagePopulator;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.project.observers.AbstractInitializeProjectObserver;
import org.ametys.web.repository.page.ModifiableSitemapElement;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.xml.sax.SAXException;

public class InitializeProjectSitemapObserver
extends AbstractInitializeProjectObserver {
    protected ObservationManager _observationManager;
    protected CurrentUserProvider _currentUserProvider;
    protected PagePopulator _pagePopulator;
    protected String _pluginName;

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._pagePopulator = (PagePopulator)((Object)manager.lookup(PagePopulator.ROLE));
    }

    @Override
    public void doObserve(Event event, Map<String, Object> transientVars, Site site, Project project) throws Exception {
        if (project != null) {
            try (AmetysObjectIterable sitemaps = site.getSitemaps();){
                for (Sitemap sitemap : sitemaps) {
                    AmetysObjectIterable pages = sitemap.getChildrenPages();
                    try {
                        if (pages.getSize() != 0L) continue;
                        this._initializeSitemap(sitemap, project);
                    }
                    finally {
                        if (pages == null) continue;
                        pages.close();
                    }
                }
            }
        }
    }

    protected void _initializeSitemap(Sitemap sitemap, Project project) {
        String path = "skin:" + sitemap.getSite().getSkinId() + "://conf/project-home-model.xml";
        try {
            this._pagePopulator.initPage((ModifiableSitemapElement)sitemap, path);
        }
        catch (IOException | ConfigurationException | SAXException e) {
            this.getLogger().error("An error occurred while trying to create and configure the project home page.", e);
        }
        this._projectManager.initializeModulesSitemap(project, sitemap);
        HashMap<String, Sitemap> eventParams = new HashMap<String, Sitemap>();
        eventParams.put("sitemap", sitemap);
        this._observationManager.notify(new Event("sitemap.updated", this._currentUserProvider.getUser(), eventParams));
    }
}

