/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.rights.accesscontroller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.rights.ContentAccessController;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.RightsException;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.right.AbstractRightBasedAccessController;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.ChainedAmetysObjectIterable;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.members.JCRProjectMember;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.WebHelper;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageQueryHelper;
import org.ametys.web.repository.page.Zone;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.rights.PageAccessController;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class CatalogNewsAccessController
extends AbstractRightBasedAccessController
implements Serviceable {
    private ProjectManager _projectManager;
    private ContentTypesHelper _cTypeHelper;
    private ProjectMemberManager _projectMemberManager;
    private AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._cTypeHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._projectMemberManager = (ProjectMemberManager)((Object)manager.lookup(ProjectMemberManager.ROLE));
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public boolean supports(Object object) {
        try {
            WebContent content;
            return object instanceof WebContent && this._cTypeHelper.isInstanceOf((Content)(content = (WebContent)object), "org.ametys.plugins.workspaces.Content.catalogNews") && StringUtils.equals((CharSequence)content.getSiteName(), (CharSequence)this._projectManager.getCatalogSiteName()) || object instanceof Page && this._isCatalogNewsPage((Page)object);
        }
        catch (ProjectManager.UnknownCatalogSiteException e) {
            return false;
        }
    }

    private boolean _isCatalogNewsPage(Page page) {
        try {
            if (page.getSiteName().equals(this._projectManager.getCatalogSiteName()) && Page.PageType.CONTAINER == page.getType() && page.hasZone("default")) {
                Zone defaultZone = page.getZone("default");
                ZoneItem cZoneItem = defaultZone.getZoneItems().stream().filter(z -> z.getType() == ZoneItem.ZoneType.CONTENT).filter(z -> this._cTypeHelper.isInstanceOf(z.getContent(), "org.ametys.plugins.workspaces.Content.catalogNews")).findFirst().orElse(null);
                return cZoneItem != null;
            }
        }
        catch (ProjectManager.UnknownCatalogSiteException unknownCatalogSiteException) {
            // empty catch block
        }
        return false;
    }

    private Content _getNewsContent(Object object) {
        if (object instanceof Content) {
            return (Content)object;
        }
        Page page = (Page)object;
        Optional<ZoneItem> zoneItem = page.getZone("default").getZoneItems().stream().filter(z -> z.getType() == ZoneItem.ZoneType.CONTENT).filter(z -> this._cTypeHelper.isInstanceOf(z.getContent(), "org.ametys.plugins.workspaces.Content.catalogNews")).findFirst();
        return zoneItem.map(zi -> zi.getContent()).orElse(null);
    }

    public AccessController.AccessResult getReadAccessPermission(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        Map<Project, JCRProjectMember.MemberType> userProjects;
        Content content = this._getNewsContent(object);
        if (content != null && content.getCreator().equals((Object)user)) {
            return AccessController.AccessResult.USER_ALLOWED;
        }
        Set tags = content != null ? content.getTags() : Collections.EMPTY_SET;
        Set<String> categories = tags.stream().filter(tag -> tag.startsWith("WORKSPACES_CATEGORY_")).map(tag -> tag.substring("WORKSPACES_CATEGORY_".length())).collect(Collectors.toSet());
        Set<String> keywords = tags.stream().filter(tag -> tag.startsWith("WORKSPACES_KEYWORD_")).map(tag -> tag.substring("WORKSPACES_KEYWORD_".length())).collect(Collectors.toSet());
        if (!(categories.isEmpty() && keywords.isEmpty() || (userProjects = this._projectManager.getUserProjects(user, categories, keywords)).isEmpty())) {
            return userProjects.values().contains((Object)JCRProjectMember.MemberType.USER) ? AccessController.AccessResult.USER_ALLOWED : AccessController.AccessResult.GROUP_ALLOWED;
        }
        return AccessController.AccessResult.UNKNOWN;
    }

    public Map<UserIdentity, AccessController.AccessResult> getReadAccessPermissionByUser(Object object) {
        HashMap<UserIdentity, AccessController.AccessResult> accessResults = new HashMap<UserIdentity, AccessController.AccessResult>();
        Content content = this._getNewsContent(object);
        if (content != null) {
            accessResults.put(content.getCreator(), AccessController.AccessResult.USER_ALLOWED);
        }
        Set tags = content != null ? content.getTags() : Collections.EMPTY_SET;
        Set<String> categories = tags.stream().filter(tag -> tag.startsWith("WORKSPACES_CATEGORY_")).map(tag -> tag.substring("WORKSPACES_CATEGORY_".length())).collect(Collectors.toSet());
        Set<String> keywords = tags.stream().filter(tag -> tag.startsWith("WORKSPACES_KEYWORD_")).map(tag -> tag.substring("WORKSPACES_KEYWORD_".length())).collect(Collectors.toSet());
        if (!categories.isEmpty() || !keywords.isEmpty()) {
            for (Project project : this._projectManager.getProjects(categories, keywords, true)) {
                Set<ProjectMemberManager.ProjectMember> projectMembers = this._projectMemberManager.getProjectMembers(project, false);
                for (ProjectMemberManager.ProjectMember member : projectMembers) {
                    if (JCRProjectMember.MemberType.USER != member.getType()) continue;
                    accessResults.put(member.getUser().getIdentity(), AccessController.AccessResult.USER_ALLOWED);
                }
            }
        }
        return accessResults;
    }

    public Map<GroupIdentity, AccessController.AccessResult> getReadAccessPermissionByGroup(Object object) {
        HashMap<GroupIdentity, AccessController.AccessResult> accessResults = new HashMap<GroupIdentity, AccessController.AccessResult>();
        Content content = this._getNewsContent(object);
        Set tags = content != null ? content.getTags() : Collections.EMPTY_SET;
        Set<String> categories = tags.stream().filter(tag -> tag.startsWith("WORKSPACES_CATEGORY_")).map(tag -> tag.substring("WORKSPACES_CATEGORY_".length())).collect(Collectors.toSet());
        Set<String> keywords = tags.stream().filter(tag -> tag.startsWith("WORKSPACES_KEYWORD_")).map(tag -> tag.substring("WORKSPACES_KEYWORD_".length())).collect(Collectors.toSet());
        if (!categories.isEmpty() || !keywords.isEmpty()) {
            for (Project project : this._projectManager.getProjects(categories, keywords, true)) {
                Set<ProjectMemberManager.ProjectMember> projectMembers = this._projectMemberManager.getProjectMembers(project, false);
                for (ProjectMemberManager.ProjectMember member : projectMembers) {
                    if (JCRProjectMember.MemberType.GROUP != member.getType()) continue;
                    accessResults.put(member.getGroup().getIdentity(), AccessController.AccessResult.GROUP_ALLOWED);
                }
            }
        }
        return accessResults;
    }

    public AccessController.AccessResult getPermission(UserIdentity user, Set<GroupIdentity> userGroups, String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public Map<String, AccessController.AccessResult> getPermissionByRight(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        return Map.of();
    }

    public AccessController.AccessResult getPermissionForAnonymous(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnonymous(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getPermissionForAnyConnectedUser(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnyConnectedUser(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public Map<UserIdentity, AccessController.AccessResult> getPermissionByUser(String rightId, Object object) {
        return Map.of();
    }

    public Map<GroupIdentity, AccessController.AccessResult> getPermissionByGroup(String rightId, Object object) {
        return Map.of();
    }

    public boolean hasUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups, String rightId) {
        return false;
    }

    public boolean hasUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups) {
        return false;
    }

    public boolean hasAnonymousAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnonymousAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    protected AccessExplanation _getAccessExplanation(AccessController.AccessResult result, Object object, UserIdentity user, Set<GroupIdentity> groups, String rightId) {
        switch (result) {
            case USER_ALLOWED: 
            case GROUP_ALLOWED: {
                Content content = this._getNewsContent(object);
                if (content != null) {
                    if (content.getCreator().equals((Object)user)) {
                        return new AccessExplanation(this.getId(), result, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_CATALOG_NEWS_ACCESS_CONTROLLER_CREATOR_EXPLANATION", Map.of("title", new I18nizableText(content.getTitle()))));
                    }
                    Set tags = content.getTags();
                    Set<String> categories = tags.stream().filter(tag -> tag.startsWith("WORKSPACES_CATEGORY_")).map(tag -> tag.substring("WORKSPACES_CATEGORY_".length())).collect(Collectors.toSet());
                    Set<String> keywords = tags.stream().filter(tag -> tag.startsWith("WORKSPACES_KEYWORD_")).map(tag -> tag.substring("WORKSPACES_KEYWORD_".length())).collect(Collectors.toSet());
                    Map<Project, JCRProjectMember.MemberType> userProjects = this._projectManager.getUserProjects(user, categories, keywords);
                    ArrayList<String> projectTitle = new ArrayList<String>();
                    for (Project project : userProjects.keySet()) {
                        projectTitle.add(project.getTitle());
                    }
                    Object key = "PLUGINS_WORKSPACES_CATALOG_NEWS_ACCESS_CONTROLLER_PROJECT_MEMBER_EXPLANATION";
                    if (projectTitle.size() > 1) {
                        key = (String)key + "_MULTIPLE";
                    }
                    return new AccessExplanation(this.getId(), result, new I18nizableText("plugin.workspaces", (String)key, Map.of("title", new I18nizableText(content.getTitle()), "projects", AccessExplanation.elementsToI18nizableText(projectTitle))));
                }
                return AccessController.getDefaultAccessExplanation((String)this.getId(), (AccessController.AccessResult)result);
            }
            case UNKNOWN: {
                String title;
                if (object instanceof Page) {
                    Page page = (Page)object;
                    title = page.getTitle();
                } else if (object instanceof Content) {
                    Content c = (Content)object;
                    title = c.getTitle();
                } else {
                    return AccessController.getDefaultAccessExplanation((String)this.getId(), (AccessController.AccessResult)result);
                }
                return new AccessExplanation(this.getId(), result, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_CATALOG_NEWS_ACCESS_CONTROLLER_UNKNOWN_EXPLANATION", Map.of("title", new I18nizableText(title))));
            }
        }
        return AccessController.getDefaultAccessExplanation((String)this.getId(), (AccessController.AccessResult)result);
    }

    public I18nizableText getObjectCategory(Object object) {
        if (object instanceof Content) {
            return ContentAccessController.CONTENT_CONTEXT_CATEGORY;
        }
        if (object instanceof Page) {
            return PageAccessController.PAGE_CONTEXT_CATEGORY;
        }
        throw new RightsException("Unsuppported context: " + object.toString());
    }

    public I18nizableText getObjectLabel(Object object) {
        if (object instanceof Content) {
            Content news = (Content)object;
            return new I18nizableText(news.getTitle());
        }
        if (object instanceof Page) {
            Page page = (Page)object;
            return new I18nizableText(PageAccessController.getPageObjectLabel((Page)page));
        }
        throw new RightsException("Unsuppported context: " + object.toString());
    }

    protected Iterable<? extends Object> getHandledObjects(UserIdentity identity, Set<GroupIdentity> groups, Set<Object> workspacesContexts) {
        String siteName = WebHelper.getSiteName((Request)ContextHelper.getRequest((Context)this._context));
        try {
            if (StringUtils.equals((CharSequence)siteName, (CharSequence)this._projectManager.getCatalogSiteName())) {
                ContentTypeExpression cTypeExpr = new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.workspaces.Content.catalogNews"});
                StringExpression siteExpression = new StringExpression("site", Expression.Operator.EQ, siteName);
                String contentQuery = ContentQueryHelper.getContentXPathQuery((Expression)new AndExpression(new Expression[]{siteExpression, cTypeExpr}));
                String pageQuery = PageQueryHelper.getPageXPathQuery((String)siteName, null, null, null, null);
                return new ChainedAmetysObjectIterable(List.of(this._resolver.query(contentQuery), this._resolver.query(pageQuery)));
            }
        }
        catch (ProjectManager.UnknownCatalogSiteException unknownCatalogSiteException) {
            // empty catch block
        }
        return List.of();
    }

    protected Collection<String> getHandledRights() {
        return List.of();
    }
}

