/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.report;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.data.holder.IndexableDataHolder;
import org.ametys.cms.repository.Content;
import org.ametys.cms.tag.Tag;
import org.ametys.core.group.GroupManager;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.StringUtils;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.activities.ActivityHelper;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.userdirectory.UserDirectoryHelper;
import org.ametys.plugins.workspaces.keywords.KeywordsDAO;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.report.ReportHelper;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ReportGenerator
extends ServiceableGenerator
implements Contextualizable {
    protected static final String __DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm";
    protected static final DateTimeFormatter __ZONED_DATE_FORMATER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    protected static final SimpleDateFormat __DATE_FORMATER = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    protected static final int __REPORT_COLUMNS_SIZE_PROJECT = 8;
    protected static final int __REPORT_COLUMNS_SIZE_MEMBER = 8;
    protected ReportHelper _reportProjectManager;
    protected ProjectManager _projectManager;
    protected SiteManager _siteManager;
    protected Repository _repository;
    protected UserManager _userManager;
    protected GroupManager _groupManager;
    protected ProjectMemberManager _projectMemberManager;
    protected UserDirectoryHelper _userDirectoryHelper;
    protected I18nUtils _i18nUtils;
    protected KeywordsDAO _keywordsDAO;
    protected Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._reportProjectManager = (ReportHelper)smanager.lookup(ReportHelper.ROLE);
        this._projectManager = (ProjectManager)((Object)smanager.lookup(ProjectManager.ROLE));
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._repository = (Repository)smanager.lookup("javax.jcr.Repository");
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._groupManager = (GroupManager)smanager.lookup(GroupManager.ROLE);
        this._projectMemberManager = (ProjectMemberManager)((Object)smanager.lookup(ProjectMemberManager.ROLE));
        this._userDirectoryHelper = (UserDirectoryHelper)smanager.lookup(UserDirectoryHelper.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
        this._keywordsDAO = (KeywordsDAO)((Object)this.manager.lookup(KeywordsDAO.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ContextHelper.getRequest((Context)this._context);
        String lang = this.parameters.getParameter("lang", null);
        String[] projectsValues = request.getParameterValues("project");
        String[] categoriesValues = request.getParameterValues("category");
        List<String> projects = projectsValues == null ? Collections.EMPTY_LIST : Arrays.asList(projectsValues).stream().filter(org.apache.commons.lang3.StringUtils::isNotBlank).collect(Collectors.toList());
        List<String> categories = categoriesValues == null ? Collections.EMPTY_LIST : Arrays.asList(categoriesValues).stream().filter(org.apache.commons.lang3.StringUtils::isNotBlank).collect(Collectors.toList());
        boolean reportWithMembers = "true".equals(request.getParameter("with-members"));
        boolean reportWithManagers = "true".equals(request.getParameter("with-managers"));
        this.contentHandler.startDocument();
        List<Project> availableProjects = this._reportProjectManager.getAvailableProjects(projects, categories);
        if (availableProjects != null && !availableProjects.isEmpty()) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"text", (String)this.generateProjects(availableProjects, reportWithMembers, reportWithManagers, lang));
        } else {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"text");
        }
        this.contentHandler.endDocument();
    }

    protected String generateProjects(List<Project> projects, boolean reportWithMembers, boolean reportWithManagers, String lang) {
        List<String> langages = this.getCatalogSiteLangages();
        StringBuilder sb = new StringBuilder();
        sb.append("\ufeff");
        sb.append("\"" + this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_TYPE", lang) + "\";");
        sb.append(this.getProjectCsvHeader(reportWithMembers, reportWithManagers, lang));
        sb.append("\n");
        sb.append(projects.stream().map(project -> this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_PROJECT", lang) + ";" + this.projectToCsv((Project)((Object)project), reportWithMembers, reportWithManagers, lang, langages)).collect(Collectors.joining("\n")));
        return sb.toString();
    }

    protected List<String> getCatalogSiteLangages() {
        Site siteCatalog;
        String catalogSiteName = this._projectManager.getCatalogSiteName();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)catalogSiteName) && (siteCatalog = this._siteManager.getSite(catalogSiteName)) != null) {
            return siteCatalog.getSitemaps().stream().map(Sitemap::getSitemapName).collect(Collectors.toList());
        }
        return null;
    }

    protected static String formatToCsv(String ... line) {
        return Arrays.stream(line).map(StringUtils::sanitizeCsv).collect(Collectors.joining(";"));
    }

    protected String getProjectCsvHeader(boolean reportWithMembers, boolean reportWithManagers, String lang) {
        StringBuilder sb = new StringBuilder(ReportGenerator.formatToCsv(this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_PROJECT_NAME", lang), this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_PROJECT_DESC", lang), this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_PROJECT_CATEGORY", lang), this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_PROJECT_CREATION_DATE", lang), this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_PROJECT_ACTIVITY_DATE", lang), this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_PROJECT_KEYWONDS", lang), this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_PROJECT_MANAGERS", lang), this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_PROJECT_VISIBILITY", lang)));
        if (reportWithMembers || reportWithManagers) {
            sb.append(";");
            sb.append(this.getMemberCsvHeader(lang));
        }
        return sb.toString();
    }

    private String getMemberCsvHeader(String lang) {
        return ReportGenerator.formatToCsv(this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_MEMBER_TITLE", lang), this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_MEMBER_FIRSTNAME", lang), this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_MEMBER_LASTNAME", lang), this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_MEMBER_FUNCTION", lang), this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_MEMBER_ORGANISATION", lang), this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_MEMBER_PHONE", lang), this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_MEMBER_MAIL", lang), this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_MEMBER_SKILLS", lang));
    }

    private String projectToCsv(Project project, boolean reportWithMembers, boolean reportWithManagers, String lang, List<String> langages) {
        Set<String> projectCategories = project.getCategories();
        String mainCategory = projectCategories.size() > 0 ? projectCategories.iterator().next() : "";
        String lastActivityDate = this.getProjectLastActivityDate(project);
        String projectmanager = Arrays.stream(project.getManagers()).map(arg_0 -> ((UserManager)this._userManager).getUser(arg_0)).filter(Objects::nonNull).map(user -> user.getFullName() + " (" + user.getIdentity().getPopulationId() + ")").collect(Collectors.joining(","));
        Project.InscriptionStatus inscriptionStatus = project.getInscriptionStatus();
        String inscriptionStatusString = Project.InscriptionStatus.PRIVATE.equals((Object)inscriptionStatus) ? this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_INSCRIPTION_STATUS_PRIVATE", lang) : (Project.InscriptionStatus.MODERATED.equals((Object)inscriptionStatus) ? this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_INSCRIPTION_STATUS_MODERATED", lang) : (Project.InscriptionStatus.OPEN.equals((Object)inscriptionStatus) ? this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_INSCRIPTION_STATUS_OPEN", lang) : ""));
        StringBuilder sb = new StringBuilder(ReportGenerator.formatToCsv(project.getTitle(), Objects.toString(project.getDescription(), "").replaceAll("[\r\n]+", " / "), mainCategory, __ZONED_DATE_FORMATER.format(project.getCreationDate()), lastActivityDate, this.getKeywords(project, lang), projectmanager, inscriptionStatusString));
        int projectPadding = reportWithMembers || reportWithManagers ? 8 : 0;
        sb.append(org.apache.commons.lang3.StringUtils.repeat((String)";-", (int)projectPadding));
        if (reportWithManagers) {
            String managerPrefix = "\"" + this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_PROJECT_MANAGER", lang) + "\";\"" + project.getTitle() + "\"" + org.apache.commons.lang3.StringUtils.repeat((String)";-", (int)7) + ";";
            String managersCsv = Arrays.stream(project.getManagers()).map(userIdentity -> this.createProjectMemberFromUser((UserIdentity)userIdentity, lang, langages)).filter(Objects::nonNull).map(ProjectMember::toCsv).map(managerCsv -> managerPrefix + managerCsv).collect(Collectors.joining("\n"));
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)managersCsv)) {
                sb.append("\n");
                sb.append(managersCsv);
            }
        }
        if (reportWithMembers) {
            String memberPrefix = "\"" + this.translateKey("PLUGIN_WORKSPACES_SERVICE_REPORTS_CSV_HEADER_PROJECT_MEMBER", lang) + "\";\"" + project.getTitle() + "\"" + org.apache.commons.lang3.StringUtils.repeat((String)";-", (int)7) + ";";
            String projectMembersCsv = this.getProjectMembersCsv(project, lang, langages).stream().map(memberCsv -> memberPrefix + memberCsv).collect(Collectors.joining("\n"));
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)projectMembersCsv)) {
                sb.append("\n");
                sb.append(projectMembersCsv);
            }
        }
        return sb.toString();
    }

    protected String getKeywords(Project project, String lang) {
        ArrayList<String> keywordLabels = new ArrayList<String>();
        for (String keyword : project.getKeywords()) {
            Tag tag = this._keywordsDAO.getTag(keyword, Collections.emptyMap());
            if (tag == null) continue;
            String title = this._i18nUtils.translate((I18nizable)tag.getTitle(), lang);
            keywordLabels.add(title);
        }
        return org.apache.commons.lang3.StringUtils.join(keywordLabels, (String)",");
    }

    protected String getProjectLastActivityDate(Project project) {
        StringExpression projectExpression = new StringExpression("projectName", Expression.Operator.EQ, project.getName());
        String xpathQuery = ActivityHelper.getActivityXPathQuery((Expression)projectExpression);
        Session session = null;
        try {
            session = this._repository.login();
            Query query = session.getWorkspace().getQueryManager().createQuery(xpathQuery, "xpath");
            NodeIterator nodes = query.execute().getNodes();
            if (nodes.hasNext()) {
                Node node = (Node)nodes.next();
                Calendar date = node.getProperty("ametys:date").getValue().getDate();
                String string = __DATE_FORMATER.format(date.getTime());
                return string;
            }
        }
        catch (RepositoryException ex) {
            throw new AmetysRepositoryException("An error occured executing the JCR query : " + xpathQuery, (Throwable)ex);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return "";
    }

    protected ProjectMember createProjectMemberFromUser(UserIdentity userIdentity, String lang, List<String> projectLanguages) {
        User user = this._userManager.getUser(userIdentity);
        if (user == null) {
            return null;
        }
        Content userContent = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)lang)) {
            userContent = this._userDirectoryHelper.getUserContent(userIdentity, lang);
        }
        if (userContent == null) {
            Content content = userContent = projectLanguages != null ? (Content)projectLanguages.stream().map(l -> this._userDirectoryHelper.getUserContent(userIdentity, l)).filter(Objects::nonNull).findFirst().orElse(null) : null;
        }
        if (userContent == null) {
            return new ProjectMember(UserIdentity.userIdentityToString((UserIdentity)userIdentity), "", user.getFirstName(), user.getLastName(), "", "", "", (String)org.apache.commons.lang3.StringUtils.defaultIfEmpty((CharSequence)user.getEmail(), (CharSequence)""), "");
        }
        IndexableDataHolder dataHolder = userContent.getDataHolder();
        ContentValue[] skillsContents = (ContentValue[])dataHolder.getValue("skills");
        String skills = skillsContents != null ? Arrays.stream(skillsContents).filter(Objects::nonNull).map(ContentValue::getContent).filter(Objects::nonNull).map(skill -> (String)skill.getDataHolder().getValue("title")).collect(Collectors.joining(",")) : "";
        return new ProjectMember(UserIdentity.userIdentityToString((UserIdentity)userIdentity), (String)org.apache.commons.lang3.StringUtils.defaultIfEmpty((CharSequence)((String)dataHolder.getValue("title")), (CharSequence)""), user.getFirstName(), user.getLastName(), (String)org.apache.commons.lang3.StringUtils.defaultIfEmpty((CharSequence)((String)dataHolder.getValue("function")), (CharSequence)""), (String)org.apache.commons.lang3.StringUtils.defaultIfEmpty((CharSequence)((String)dataHolder.getValue("organisation")), (CharSequence)""), (String)org.apache.commons.lang3.StringUtils.defaultIfEmpty((CharSequence)((String)dataHolder.getValue("phone")), (CharSequence)""), (String)org.apache.commons.lang3.StringUtils.defaultIfEmpty((CharSequence)user.getEmail(), (CharSequence)""), skills);
    }

    protected List<String> getProjectMembersCsv(Project project, String lang, List<String> languages) {
        return this._projectMemberManager.getProjectMembers(project, true).stream().map(member -> this.createProjectMemberFromUser(member.getUser().getIdentity(), lang, languages)).sorted(Comparator.comparing(ProjectMember::getSortableName)).map(ProjectMember::toCsv).collect(Collectors.toList());
    }

    protected String translateKey(String key, String lang) {
        I18nizableText i18n = new I18nizableText("plugin.workspaces", key);
        return this._i18nUtils.translate((I18nizable)i18n, lang);
    }

    static class ProjectMember {
        private String _id;
        private String _title;
        private String _firstname;
        private String _lastname;
        private String _role;
        private String _structure;
        private String _telephone;
        private String _email;
        private String _skills;

        ProjectMember(String id, String title, String firstname, String lastname, String role, String structure, String telephone, String email, String skills) {
            this._id = id;
            this._title = title;
            this._firstname = firstname;
            this._lastname = lastname;
            this._role = role;
            this._structure = structure;
            this._telephone = telephone;
            this._email = email;
            this._skills = skills;
        }

        public String getId() {
            return this._id;
        }

        public String getSortableName() {
            return this._lastname + " " + this._firstname;
        }

        public boolean equals(Object obj) {
            return this._id != null && obj instanceof ProjectMember && this._id.equals(((ProjectMember)obj).getId());
        }

        public String toCsv() {
            return ReportGenerator.formatToCsv(this._title, this._firstname, this._lastname, this._role, this._structure, this._telephone, this._email, this._skills);
        }

        public int hashCode() {
            return this._id.hashCode();
        }
    }
}

