/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
// Fix WORKSPACES-1284 Update modules property on projects

const oldModuleId = "org.ametys.plugins.workspaces.editionfo.EditionFOWorkspaceModule";
const newModuleId = "org.ametys.plugins.workspaces.about.AboutWorkspaceModule";

let count = 0;

function migrateModule(oldModuleId, newModuleId, s)
{
    let query = `//element(*, ametys:project)[@ametys:modules='${oldModuleId}']`;
    
    Repository.query(query, true, s).forEach(function(project)             
    {      
        project.removeModule(oldModuleId);
        project.addModule(newModuleId);
        count++;
    });     
    
    s.save();
    
    logger.info(`${count} project(s) have been updated`);
}

logger.info("Start migration of about module id for projects for default session");
migrateModule(oldModuleId, newModuleId, session);
logger.info("Start migration of about module id for projects for live session");
migrateModule(oldModuleId, newModuleId, Repository.liveSession);
