/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

const unversionedDataTypeExtensionPoint = Ametys.serviceManager.lookup('org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint.Unversioned');
const richTextTransformer = Ametys.serviceManager.lookup('org.ametys.cms.transformation.docbook.DocbookTransformer');
const workspaceExplorerResourceCommentsDAO = Ametys.serviceManager.lookup('org.ametys.plugins.workspaces.documents.WorkspaceExplorerResourceCommentsDAO');
const userManager = Ametys.serviceManager.lookup(org.ametys.core.user.UserManager.ROLE);

logger.info("Start replacing repository primary type for default session");
convertRootFolder(Repository.session);

logger.info("Start replacing repository primary type migration for live session");
convertRootFolder(Repository.liveSession);

function convertRootFolder(session) 
{
    let count = 0;
    const xpath = "//element(*, ametys:project)/ametys-internal:resources/documents";
    const projectDocumentNodes = Repository.query(xpath, false, session);
            
    while (projectDocumentNodes.hasNext())
    {
        let node = projectDocumentNodes.next();
        convertDocumentPrimaryType(node)
        count++;
    }
    logger.info(`${count} project with repository resources have been migrated in ${session.getWorkspace().getName()} workspace`);
    session.save();
}


function convertDocumentPrimaryType(node) 
{
    let primaryType = node.getPrimaryNodeType().getName();
    if (primaryType == "ametys:resources-collection")
    {
        node.setPrimaryType("ametys:folder");
        node.save();
        let children = node.getNodes();
        while (children.hasNext())
        {
            let child = children.next();
            convertDocumentPrimaryType(child);
        }
    }
    else if (primaryType == "ametys:folder")
    {
        let children = node.getNodes();
        while (children.hasNext())
        {
            let child = children.next();
            convertDocumentPrimaryType(child);
        }
    }
    else if (primaryType == "ametys:resource")
    {
        node.setPrimaryType("ametys:file");
        node.save();
    }
}
