<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:escape="org.apache.commons.lang.StringEscapeUtils"
                xmlns:math="java.lang.Math"
                xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametysProject="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
                extension-element-prefixes="ametys escape math user resolver">
                
    <xsl:import href="service:web://pages/services/common.xsl"/>
    <xsl:import href="plugin:core-impl://stylesheets/vuejs/helper.xsl" /> 
    <xsl:import href="../../common.xsl"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:variable name="common-service-name">module-document</xsl:variable>
    
    <xsl:template name="common-service-head-title"/>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="common-workspaces-js"/>
        <script type="text/javascript" src="{ametys:pluginResourceURL('workspaces', 'js/vendor/velocity/velocity.min.js')}"></script>
        
        <xsl:call-template name="vuejs-head">          
            <xsl:with-param name="component">members</xsl:with-param>          
            <xsl:with-param name="location" select="ametys:pluginResourceURL('workspaces', 'vuejs/members')"/>  
        </xsl:call-template>   
    </xsl:template>
    
    <xsl:template name="common-service-head-css">
        <xsl:call-template name="common-workspaces-css"/>
    </xsl:template>
        
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="vuejs">          
            <xsl:with-param name="component">members</xsl:with-param>          
            <xsl:with-param name="location" select="ametys:pluginResourceURL('workspaces', 'vuejs/members')"/>   
            <xsl:with-param name="uniqueId">members-module</xsl:with-param>
            <xsl:with-param name="config">{}</xsl:with-param>
        </xsl:call-template> 
    </xsl:template>

</xsl:stylesheet>
