<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2016 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:math="java.lang.Math"
                xmlns:uriutils="org.ametys.core.util.URIUtils"
                extension-element-prefixes="ametys math resolver">
                
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:variable name="header" select="string(ametys:serviceParameter('header')/text())"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">activity-stream</xsl:variable>
    <xsl:variable name="common-service-name">service-activity-stream</xsl:variable>
    
    <xsl:variable name="date-format" select="ametys:translate('plugin.workspaces:PLUGINS_WORKSPACES_SERVICE_SIMPLE_DOCUMENT_DATE_FORMAT')"></xsl:variable>
    <xsl:variable name="time-format" select="ametys:translate('plugin.workspaces:PLUGINS_WORKSPACES_SERVICE_SIMPLE_DOCUMENT_TIME_FORMAT')"></xsl:variable>
    
    <!-- +
         | HEAD
         + -->   
    <!-- Used by common -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- +
         | BODY
         + -->
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
    	<xsl:choose>
    		<xsl:when test="events/events">
    			<xsl:call-template name="events"/>
    		</xsl:when>
    		<xsl:otherwise>
    			<xsl:call-template name="events-empty"/>
    		</xsl:otherwise>
    	</xsl:choose>
    </xsl:template>
    
    <xsl:template name="events">
    	<ul class="as-entries">
	        <xsl:apply-templates select="events/events">
	            <xsl:sort select="date-iso" order="descending" />
	        </xsl:apply-templates>
	   	</ul>
    </xsl:template>
    
    <xsl:template name="events-empty">
    	<p><i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_SIMPLE_ACTIVITY_STREAM_NO_RESULTS" /></p>
    </xsl:template>
    
    <!-- +
         | CALENDARS
         + -->
    <xsl:template match="events[category='calendars']">
        <li class="as-entry as-entry-calendar">
        	<xsl:call-template name="as-entry-dates" />
        	
        	<xsl:call-template name="as-calendar-event-desc"/>
        </li>
    </xsl:template>
    
    <xsl:template name="as-calendar-event-desc">
    	<div class="as-event-desc">
	    	<xsl:choose>
	    		<xsl:when test="type = 'calendar.event.created' and amount = 1">
	    			<i18n:translate>
			            <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_CALENDAR_ADDED_WITH_PROJECT_DESC" />
			            <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
			            <i18n:param name="event"><xsl:call-template name="as-calendar-event-title"/></i18n:param>
			            <i18n:param name="calendar"><xsl:call-template name="as-calendar-calendar-title"/></i18n:param>
			            <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
			        </i18n:translate>
	            </xsl:when>
                <xsl:when test="type = 'calendar.event.updated' and amount = 1">
                    <i18n:translate>
                        <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_CALENDAR_UPDATED_WITH_PROJECT_DESC" />
                        <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
                        <i18n:param name="event"><xsl:call-template name="as-calendar-event-title"/></i18n:param>
                        <i18n:param name="calendar"><xsl:call-template name="as-calendar-calendar-title"/></i18n:param>
                        <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
                    </i18n:translate>
                </xsl:when>
                <xsl:when test="type = 'calendar.event.deleting' and amount = 1">
                    <i18n:translate>
                        <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_CALENDAR_DELETED_WITH_PROJECT_DESC" />
                        <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
                        <i18n:param name="event"><xsl:call-template name="as-calendar-event-title"/></i18n:param>
                        <i18n:param name="calendar"><xsl:call-template name="as-calendar-calendar-title"/></i18n:param>
                        <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
                    </i18n:translate>
                </xsl:when>
	            <xsl:when test="type = 'calendar.event.created' and amount > 1">
	    			<i18n:translate>
			            <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_CALENDAR_ADDED_MULTI_WITH_PROJECT_DESC" />
			            <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
			            <i18n:param name="events"><xsl:call-template name="as-calendar-event-title"/></i18n:param>
			            <i18n:param name="calendar"><xsl:call-template name="as-calendar-calendar-title"/></i18n:param>
			            <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
			        </i18n:translate>
	            </xsl:when>
	            <xsl:when test="type = 'calendar.event.updated' and amount > 1">
	    			<i18n:translate>
			            <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_CALENDAR_UPDATED_MULTI_WITH_PROJECT_DESC" />
			            <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
			            <i18n:param name="events"><xsl:call-template name="as-calendar-event-title"/></i18n:param>
			            <i18n:param name="calendar"><xsl:call-template name="as-calendar-calendar-title"/></i18n:param>
			            <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
			        </i18n:translate>
	            </xsl:when>
                <xsl:when test="type = 'calendar.event.deleted' and amount > 1">
                    <i18n:translate>
                        <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_CALENDAR_DELETED_MULTI_WITH_PROJECT_DESC" />
                        <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
                        <i18n:param name="event"><xsl:call-template name="as-calendar-event-title"/></i18n:param>
                        <i18n:param name="calendar"><xsl:call-template name="as-calendar-calendar-title"/></i18n:param>
                        <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
                    </i18n:translate>
                </xsl:when>
	    	</xsl:choose>
		</div>
    </xsl:template>
    
    <xsl:template name="as-calendar-event-title">
    	<xsl:for-each select="events/events">
           <xsl:if test="position() != 1"><xsl:call-template name="as-separator"/></xsl:if>
           <a href="{eventUrl}" target="_blank" class="as-calendar-event-title"><xsl:value-of select="eventTitle" /></a>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="as-calendar-calendar-title">
    	<span class="as-calendar"><xsl:value-of select="calendarTitle" /></span>
    </xsl:template>
    
    <!-- +
         | DOCUMENTS
         + -->
    <xsl:template match="events[category='documents']">
        <li class="as-entry as-entry-document">
        	<xsl:call-template name="as-entry-dates" />
        	
        	<xsl:call-template name="as-document-event-desc"/>
        </li>
    </xsl:template>
    
    <xsl:template name="as-document-event-desc">
    	<div class="as-event-desc">
    		<xsl:choose>
	    		<xsl:when test="type = 'resource.created' and amount = 1">
	    			<i18n:translate>
			            <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_DOCUMENT_ADDED_WITH_PROJECT_DESC" />
			            <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
			            <i18n:param name="folder"><xsl:call-template name="as-document-folder"/></i18n:param>
			            <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
			        </i18n:translate>
	            </xsl:when>
	            <xsl:when test="type = 'resource.updated' and amount = 1">
	            	<i18n:translate>
			            <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_DOCUMENT_UPDATED_WITH_PROJECT_DESC" />
			            <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
			            <i18n:param name="folder"><xsl:call-template name="as-document-folder"/></i18n:param>
			            <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
			        </i18n:translate>
	            </xsl:when>
	            <xsl:when test="type = 'resource.renamed' and amount > 1">
	    			<i18n:translate>
			            <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_DOCUMENT_RENAMED_WITH_PROJECT_DESC" />
			            <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
			            <i18n:param name="folder"><xsl:call-template name="as-document-folder"/></i18n:param>
			            <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
			        </i18n:translate>
	            </xsl:when>
	            <xsl:when test="type = 'resource.created'">
	    			<i18n:translate>
			            <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_DOCUMENT_ADDED_MULTI_WITH_PROJECT_DESC" />
			            <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
			            <i18n:param name="nb"><xsl:value-of select="count(files/files)"/></i18n:param>
			            <i18n:param name="folder"><xsl:call-template name="as-document-folder"/></i18n:param>
			            <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
			        </i18n:translate>
	            </xsl:when>
	            <xsl:when test="type = 'resource.updated'">
	    			<i18n:translate>
			            <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_DOCUMENT_UPDATED_MULTI_WITH_PROJECT_DESC" />
			            <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
			            <i18n:param name="nb"><xsl:value-of select="count(files/files)"/></i18n:param>
			            <i18n:param name="folder"><xsl:call-template name="as-document-folder"/></i18n:param>
			            <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
			        </i18n:translate>
	            </xsl:when>
	            <xsl:when test="type = 'resource.renamed'">
	    			<i18n:translate>
			            <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_DOCUMENT_RENAMED_MULTI_WITH_PROJECT_DESC" />
			            <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
			            <i18n:param name="nb"><xsl:value-of select="count(files/files)"/></i18n:param>
			            <i18n:param name="folder"><xsl:call-template name="as-document-folder"/></i18n:param>
			            <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
			        </i18n:translate>
	            </xsl:when>
	    	</xsl:choose>
	    	
	    	<xsl:call-template name="as-document-files"/>
    	</div>
    </xsl:template>
    
    <xsl:template name="as-document-folder">
    	<a href="{parentFolderUrl}" target="_blank" class="as-folder"><xsl:value-of select="parentFolder" /></a>
    </xsl:template>
    
    <xsl:template name="as-document-files">
    	<ul class="as-files">
    		<!-- Limit to first 5 documents -->
            <xsl:for-each select="files/files[position() &lt; 6]">
                <li>
                    <xsl:call-template name="as-document-file" />
                </li>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
    <xsl:template name="as-document-file">
    	<a class="as-file" href="{resolver:resolve('project-resource', id, true())}"><xsl:value-of select="name"/></a>
    </xsl:template>
    
    <!-- +
         | TASKS
         + -->
    <xsl:template match="events[category='tasks']">
        <li class="as-entry as-entry-task">
        	<xsl:call-template name="as-entry-dates" />
        	
        	<xsl:call-template name="as-task-event-desc"/>
        </li>
    </xsl:template>
    
    <xsl:template name="as-task-event-desc">
    	<div class="as-event-desc">
    		<xsl:choose>
	    		<xsl:when test="type = 'task.created' and amount = 1">
	    			<i18n:translate>
			            <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_TASK_ADDED_WITH_PROJECT_DESC" />
			            <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
			            <i18n:param name="task"><xsl:call-template name="as-task-title"/></i18n:param>
			            <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
			        </i18n:translate>
	            </xsl:when>
	            <xsl:when test="type = 'task.created' and amount > 1">
	    			<i18n:translate>
			            <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_TASKS_ADDED_WITH_PROJECT_DESC" />
			            <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
			            <i18n:param name="nb"><xsl:value-of select="count(tasks/tasks)"/></i18n:param>
			            <i18n:param name="tasks"><xsl:call-template name="as-task-title"/></i18n:param>
			            <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
			        </i18n:translate>
	            </xsl:when>
                <xsl:when test="type = 'task.assigned'">
                    <i18n:translate>
                        <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_TASK_ASSIGNED_WITH_PROJECT_DESC" />
                        <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
                        <i18n:param name="task"><xsl:call-template name="as-task-title"/></i18n:param>
                        <i18n:param name="assignee"><xsl:call-template name="as-task-assignee"/></i18n:param>
                        <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
                    </i18n:translate>
                </xsl:when>
	            <xsl:when test="type = 'task.closed.status.changed' and isClosed = 'true'">
	    			<i18n:translate>
			            <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_TASK_CLOSED_STATUS_CLOSE_WITH_PROJECT_DESC" />
			            <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
			            <i18n:param name="task"><xsl:call-template name="as-task-title"/></i18n:param>
			            <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
			        </i18n:translate>
	            </xsl:when>
	            <xsl:when test="type = 'task.closed.status.changed' and isClosed = 'false'">
                    <i18n:translate>
                        <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_TASK_CLOSED_STATUS_OPEN_WITH_PROJECT_DESC" />
                        <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
                        <i18n:param name="task"><xsl:call-template name="as-task-title"/></i18n:param>
                        <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
                    </i18n:translate>
                </xsl:when>
	    	</xsl:choose>
    	</div>
    </xsl:template>
    
    <xsl:template name="as-task-assignee">
    	<span class="as-task-assignee"><xsl:value-of select="assignees"/></span>
    </xsl:template>
    
    <xsl:template name="as-task-title">
    	<xsl:for-each select="tasks/tasks">
           <xsl:if test="position() != 1"><xsl:call-template name="as-separator"/></xsl:if>
           <a class="as-task-title" target="_blank" href="{taskUrl}"><xsl:value-of select="taskTitle" /></a>
        </xsl:for-each>
    </xsl:template>
    
    <!-- +
         | THREADS
         + -->
    <xsl:template name="as-thread-title">
    	<xsl:choose>
    		<xsl:when test="threads/threads">
    			<xsl:for-each select="threads/threads">
		           <xsl:if test="position() != 1"><xsl:call-template name="as-separator"/></xsl:if>
		           <a href="{threadUrl}" target="_blank" class="as-thread-title"><xsl:value-of select="threadTitle" /></a>
		        </xsl:for-each>
    		</xsl:when>
    		<xsl:otherwise>
    			<a href="{threadUrl}" target="_blank" class="as-thread-title"><xsl:value-of select="threadTitle" /></a>
    		</xsl:otherwise>
    	</xsl:choose>
    </xsl:template>
    
    <xsl:template name="as-thread-post">
    	<div class="as-thread-post"><xsl:value-of select="message" /></div>
    </xsl:template>
    
    <!-- +
         | PROJECTS
         + -->
    <xsl:template match="events[category='projects']">
    	<li class="as-entry as-entry-member">
        	<xsl:call-template name="as-entry-dates" />
        	
        	<xsl:call-template name="as-project-member-desc"/>
        </li>
    </xsl:template>
    
    <xsl:template name="as-project-member-desc">
    	<div class="as-event-desc">
    		<xsl:choose>
	    		<xsl:when test="type = 'member.added' and amount = 1">
	    			<i18n:translate>
			            <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_MEMBER_ADDED_DESC" />
			            <i18n:param name="member"><xsl:call-template name="as-project-member"/></i18n:param>
			            <i18n:param name="project"><xsl:call-template name="as-memberof-project"/></i18n:param>
			        </i18n:translate>
	    		</xsl:when>
	    		<xsl:when test="type = 'member.added'">
	    			<i18n:translate>
			            <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_MEMBERS_ADDED_DESC" />
			            <i18n:param name="members"><xsl:call-template name="as-project-member"/></i18n:param>
			            <i18n:param name="project"><xsl:call-template name="as-memberof-project"/></i18n:param>
			        </i18n:translate>
	    		</xsl:when>
                <xsl:when test="type = 'wallcontent.added'">
                    <i18n:translate>
			            <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_WALLCONTENT_ADDED_WITH_PROJECT_DESC" />
			            <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
			            <i18n:param name="thread"><xsl:call-template name="as-thread-title"/></i18n:param>
			            <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
			        </i18n:translate>
                    <xsl:if test="normalize-space(contentSummary) != ''">
                        <div class="as-event-summary"><xsl:value-of select="contentSummary"/></div>       
                    </xsl:if>
                </xsl:when>
                <xsl:when test="type= 'content.comment.validated'">
                    <i18n:translate>
			            <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_WALLCONTENT_COMMENTED_WITH_PROJECT_DESC" />
			            <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
			            <i18n:param name="thread"><xsl:call-template name="as-thread-title"/></i18n:param>
			            <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
			        </i18n:translate>
                    <xsl:if test="normalize-space(commentSummary) != ''">
                        <div class="as-event-summary"><xsl:value-of select="commentSummary"/></div>       
                    </xsl:if>
                </xsl:when>
	    	</xsl:choose>
    	</div>
    </xsl:template>
    
    <xsl:template name="as-project-member">
    	<xsl:for-each select="members/members">
            <xsl:if test="position() != 1"><xsl:call-template name="as-separator"/></xsl:if>
            <xsl:value-of select="name" />
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="as-memberof-project">
    	<span class="as-memberof-project"><xsl:value-of select="projectTitle"/></span>
    </xsl:template>
    
    <!-- +
         | MINISITE
         + -->
    <xsl:template match="events[category='minisite']">
    	<li class="as-entry as-entry-minisite">
        	<xsl:call-template name="as-entry-dates" />
        	
        	<xsl:call-template name="as-minisite-desc"/>
        </li>
    </xsl:template>
    
    <xsl:template name="as-minisite-desc">
    	<div class="as-event-desc">
            <xsl:choose>
                <xsl:when test="type = 'minisite.page.created' and amount = 1">
                    <i18n:translate>
                        <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_PAGE_CREATED_DESC" />
                        <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
                        <i18n:param name="page"><xsl:call-template name="as-minisite-page-title"/></i18n:param>
                        <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
                    </i18n:translate>
                </xsl:when>
                <xsl:when test="type = 'minisite.page.created' and amount > 1">
                    <i18n:translate>
                        <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_PAGES_CREATED_DESC" />
                        <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
                        <i18n:param name="pages"><xsl:call-template name="as-minisite-page-title"/></i18n:param>
                        <i18n:param name="nb"><xsl:value-of select="count(pages/pages)"/></i18n:param>
                        <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
                    </i18n:translate>
                </xsl:when>
                <xsl:when test="type = 'minisite.page.updated' and amount = 1">
                    <i18n:translate>
                        <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_PAGE_UPDATED_DESC" />
                        <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
                        <i18n:param name="page"><xsl:call-template name="as-minisite-page-title"/></i18n:param>
                        <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
                    </i18n:translate>
                </xsl:when>
                <xsl:when test="type = 'minisite.page.updated' and amount > 1">
                    <i18n:translate>
                        <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_PAGES_UPDATED_DESC" />
                        <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
                        <i18n:param name="pages"><xsl:call-template name="as-minisite-page-title"/></i18n:param>
                        <i18n:param name="nb"><xsl:value-of select="count(pages/pages)"/></i18n:param>
                        <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
                    </i18n:translate>
                </xsl:when>
                <xsl:when test="type = 'minisite.page.deleted' and amount = 1">
                    <i18n:translate>
                        <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_PAGE_DELETED_DESC" />
                        <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
                        <i18n:param name="page"><xsl:call-template name="as-minisite-deleted-page-title"/></i18n:param>
                        <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
                    </i18n:translate>
                </xsl:when>
                <xsl:when test="type = 'minisite.page.deleted' and amount > 1">
                    <i18n:translate>
                        <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_PAGE_DELETED_DESC" />
                        <i18n:param name="author"><xsl:call-template name="as-entry-author"/></i18n:param>
                        <i18n:param name="pages"><xsl:call-template name="as-minisite-deleted-page-title"/></i18n:param>
                        <i18n:param name="nb"><xsl:value-of select="count(pages/pages)"/></i18n:param>
                        <i18n:param name="project"><xsl:call-template name="as-entry-project"/></i18n:param>
                    </i18n:translate>
                </xsl:when>
            </xsl:choose>
    	</div>
    </xsl:template>
    
    <xsl:template name="as-minisite-page-title">
        <xsl:for-each select="pages/pages">
           <xsl:if test="position() != 1"><xsl:call-template name="as-separator"/></xsl:if>
           <a class="as-page-title" target="_blank" href="{resolver:resolve('page', pageId)}"><xsl:value-of select="pageTitle" /></a>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="as-minisite-deleted-page-title">
        <xsl:for-each select="pages/pages">
           <xsl:if test="position() != 1"><xsl:call-template name="as-separator"/></xsl:if>
           <span class="as-page-title"><xsl:value-of select="pageTitle" /></span>
        </xsl:for-each>
    </xsl:template>
    
    <!-- +
         | Common templates
         + -->
    <xsl:template name="as-entry-project">
        <xsl:choose>
            <xsl:when test="hasProjectAccess = 'true'">
                <a href="{projectUrl}" target="_blank" class="as-entry-project" title="plugin.workspaces:PLUGINS_WORKSPACES_SERVICE_SIMPLE_PROJECTS_CATALOGUE_ACCESS" i18n:attr="title"><xsl:value-of select="projectTitle" /></a>
            </xsl:when>
            <xsl:otherwise>
		        <span class="as-entry-project"><xsl:value-of select="projectTitle" /></span>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="as-entry-author">
        <span class="as-entry-author">
        	<img src="{$site-uri-prefix}/_plugins/core-ui/user/{author/populationId}/{uriutils:encodePath(author/login)}/image_26" alt="" title="{author/fullname}"/>
        	<xsl:value-of select="author/fullname" />
        </span>
    </xsl:template>
    
    <xsl:template name="as-entry-dates">
    	<div class="as-entry-date">
    		<!-- Day -->
    		<i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-format}" value="{date-iso}"/>
    		<xsl:text> </xsl:text>
    		
    		<!-- Time -->
    		<xsl:choose>
    			<xsl:when test="string(end-date-iso) = ''">
    				 <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_AT"/><xsl:text> </xsl:text>
    				 <i18n:date-time src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$time-format}" value="{date-iso}"/>
    			</xsl:when>
    			<xsl:otherwise>
    				<i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_BETWEEN"/><xsl:text> </xsl:text>
	                <i18n:date-time src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$time-format}" value="{date-iso}" />
	                <xsl:text> </xsl:text>
	                <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_AND"/>
	                <xsl:text> </xsl:text>
	                <i18n:date-time src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$time-format}" value="{end-date-iso}" />
    			</xsl:otherwise>
    		</xsl:choose>
         </div>
    </xsl:template>
    
    <xsl:template name="as-separator"><xsl:text>, </xsl:text></xsl:template>
    
    <xsl:template match="events" />
    
</xsl:stylesheet>
