/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Class to handle project resource link
 * @private
 */
Ext.define('Ametys.plugins.workspaces.editor.ProjectResourceLinkHandler', {
    extend: 'Ametys.cms.editor.LinkHandler',
    
    edit: function (href)
    {
    	Ametys.plugins.cms.editor.Links._doInsertProjectResourceLink(href);
    },
    
    getTypeName: function()
    {
    	return "{{i18n CONTENT_EDITION_LINK_VIEW_PROJECT_RESOURCE_LABEL}}";
    },
    
    getTitle: function(href)
    {
        var response = Ametys.data.ServerComm.send({
        	plugin: 'cms',
			url: 'resource/info',
            parameters: {id: href}, 
            priority: Ametys.data.ServerComm.PRIORITY_SYNCHRONOUS 
        });
        if (response == null || response.getAttribute("code") == "500" || response.getAttribute("code") == "404" || Ext.dom.Query.selectNode('resources > resource', response) == null)
		{
			return "{{i18n CONTENT_EDITION_LINK_VIEW_PROJECT_RESOURCE_ERROR}}";
		}
		
		return Ext.dom.Query.selectNode('resources > resource', response).getAttribute("name");
    },
    
    getDescription: function(href)
    {
    	var response = Ametys.data.ServerComm.send({
			plugin: 'cms',
			url: 'resource/info',
			parameters: {id: href}, 
			priority: Ametys.data.ServerComm.PRIORITY_SYNCHRONOUS
		});
		
		if (response == null || response.getAttribute("code") == "500" || response.getAttribute("code") == "404" || Ext.dom.Query.selectNode('resources > resource', response) == null)
		{
			return "{{i18n CONTENT_EDITION_LINK_VIEW_PROJECT_RESOURCE_ERROR_DESC}}";
		}
		
		return "{{i18n CONTENT_EDITION_LINK_VIEW_PROJECT_RESOURCE_DESCRIPTION}}" + Ext.dom.Query.selectNode('resources > resource', response).getAttribute("path");
	}
});

