/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This tool displays the JCR tags in a tree 
 * @private
 */
Ext.define('Ametys.plugins.workspaces.project.category.tool.CategoriesTool', {
    extend : 'Ametys.plugins.cms.tag.tool.TagsTool',

    _tagTooltipTpl : Ext.create('Ext.XTemplate', [
                         '<tpl if="description && description != \'\'">',
                            '{description}<br/>',
                         '</tpl>',
                         '<tpl if="color && color != \'\'">',
                            '<u>{{i18n PLUGINS_WORKSPACES_CATEGORIES_TEMPLATE_TOOLTIP_COLOR}}</u> : <span class="{class}-tooltip-{color}" /><br/>',
                         '<tpl else>',
                         '<u>{{i18n PLUGINS_WORKSPACES_CATEGORIES_TEMPLATE_TOOLTIP_COLOR}}</u> : <span class="{class}-tooltip-default" /><br/>',
                         '</tpl>'   
    ]),
    
    _rootNodeLabel : "{{i18n PLUGINS_WORKSPACES_CATEGORIES_ROOT_NODE_LABEL}}",
       
    getTagProviderId: function()
    {
    	return 'org.ametys.plugins.workspaces.categories.CategoryJCRProvider';
    },
    
    getTagProviderEPId: function()
    {
    	return 'org.ametys.plugins.workspaces.categories.CategoryProviderExtensionPoint';
    },
    
    getTagDAO: function()
    {
    	return 'org.ametys.plugins.workspaces.categories.CategoryJCRDAO';
    },
    
    getTagModel: function()
    {
    	return 'Ametys.plugins.workspaces.project.category.CategoryNode';
    },
    
    getTagTargetMessage: function()
    {
    	return Ametys.message.MessageTarget.PROJECT_CATEGORY;
    },
    
    getRootTagTargetMessage: function()
    {
    	return Ametys.message.MessageTarget.PROJECT_CATEGORY_ROOT;
    },

	_getTooltip: function(node)
	{
		var title = node.get('name');
		if (node.get("title") != null)
		{
			title = node.get('title') + " (" + title + ")";
		}
		
		var text = this._tagTooltipTpl.applyTemplate ({
			description: node.get('description'),
			color: node.get('color'),
		});
		
		return {
			title: title,
			glyphIcon: node.get('tooltipIconCls'),
			imageWidth: 48,
			imageHeight: 48,
			text: text,
			inribbon: false
		};
	},
    
	_updateAdditionalInfo : function (node, response)
    {
		node.set('color', response['color']);
        node.set('class', response['class']);
    }
});

Ext.define("Ametys.message.ProjectCategoryMessageTarget",
    {
		override: "Ametys.message.MessageTarget",

	    statics: 
	    {
	        /**
	         * @member Ametys.message.MessageTarget
	         * @readonly
	         * @property {String} PROJECT_CATEGORY The target type is a tag. The expected parameters are:
	         * @property {String} PROJECT_CATEGORY.id The id of tag
	         * @property {String} PROJECT_CATEGORY.parentId The id of the parent of the tag
	         * @property {String} PROJECT_CATEGORY.name The name of tag
	         */
	    	PROJECT_CATEGORY: "project-category",
	
	        /**
	         * @member Ametys.message.MessageTarget
	         * @readonly
	         * @property {String} PROJECT_CATEGORY_ROOT The target type is a tag root. The expected parameters are:
	         * @property {String} PROJECT_CATEGORY_ROOT.id The id of root tag
	         * @property {String} PROJECT_CATEGORY_ROOT.name The name of root tag 
	         */
	    	PROJECT_CATEGORY_ROOT: "project-category-root"
	    }
    }
);
