<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent">
    
    <xsl:import href="view://stylesheets/mail/abstract2notification.xsl"/>
    <xsl:import href="view://stylesheets/utils.xsl"/>
    
    <xsl:template match="activity">
        <item type="content">
            <xsl:apply-templates select="." mode="content-title"/>
            <xsl:apply-templates select="." mode="content-author"/>
            <xsl:apply-templates select="." mode="content-date"/>
            <xsl:apply-templates select="." mode="content-detail"/>
            <xsl:apply-templates select="." mode="content-image"/>
            <comments>
                <xsl:choose>
                    <xsl:when test="parentComment"><xsl:apply-templates select="." mode="parent-comment"/></xsl:when>
                    <xsl:otherwise><xsl:apply-templates select="." mode="comment"/></xsl:otherwise>
                </xsl:choose>
            </comments>
        </item>
    </xsl:template>
    
    <xsl:template match="activity" mode="content-title">
        <title><xsl:value-of select="contentTitle"/></title>
    </xsl:template>
    
    <xsl:template match="activity" mode="content-author">
        <author>
            <login><xsl:value-of select="contentCreator/@login"/></login>
            <populationId><xsl:value-of select="contentCreator/@populationId"/></populationId>
            <fullname><xsl:value-of select="contentCreator"/></fullname>
        </author>
    </xsl:template>
    
    <xsl:template match="activity" mode="content-date">
        <date><xsl:value-of select="contentCreationDate"/></date>
    </xsl:template>
    
    <xsl:template match="activity" mode="content-detail">
        <content>
            <xsl:value-of select="contentSummary"/>
        </content>
    </xsl:template>
    
    <xsl:template match="activity" mode="content-image">
        <xsl:if test="ametys:hasValue(contentId, 'illustration/image')">
            <xsl:variable name="img" select="ametys:contentAttribute(contentId, 'illustration/image')"/>
            <images>
                <image>
                    <src><xsl:value-of select="resolver:resolveBoundedImageAsBase64($img/@type, $img/@uri, 340, 490)"/></src>
                    <alt><xsl:value-of select="ametys:contentAttribute(contentId, 'illustration/alt-text')"/></alt>
                </image>
            </images>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="activity" mode="parent-comment">
        <comment new="false">
            <author>
                <xsl:choose>
                    <xsl:when test="parentComment/author">
                        <login><xsl:value-of select="parentComment/author/@login"/></login>
                        <populationId><xsl:value-of select="parentComment/author/@populationId"/></populationId>
                        <fullname><xsl:value-of select="parentComment/author"/></fullname>
                    </xsl:when>
                    <xsl:otherwise>
                        <fullname><xsl:value-of select="parentComment/author_fullname"/></fullname>
                    </xsl:otherwise>
                </xsl:choose>
            </author>
            <id><xsl:value-of select="parentComment/commentId"/></id>
            <datetime><xsl:value-of select="parentComment/date"/></datetime>
            <content><xsl:value-of select="parentComment/commentSummary"/></content>
            <sub-comments>
                <xsl:apply-templates select="." mode="comment"/>
            </sub-comments>
        </comment>
    </xsl:template>
    
    <xsl:template match="comments|sub-comments">
        <xsl:copy>
            <xsl:apply-templates select="comment[@id = /notification/newComment] | comment[sub-comments/comment/@id = /notification/newComment]"/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="activity" mode="comment">
        <comment>
            <xsl:apply-templates select="." mode="date"/>
            <xsl:apply-templates select="." mode="author"/>
            <content><xsl:value-of select="commentSummary"/></content>
            <id><xsl:value-of select="commentId"/></id>
        </comment>
    </xsl:template>
    
    <xsl:template name="section-button">
        <button>
            <text>
                <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_BODY_DEFAULT_BUTTON_TEXT" i18n:catalogue="plugin.workspaces"/>
            </text>
            <href>
                <xsl:choose>
                    <xsl:when test="activity/pageId != ''"><xsl:value-of select="resolver:resolve('page', activity/pageId, false(), true())"/></xsl:when>
                    <xsl:when test="modulePageId != ''"><xsl:value-of select="resolver:resolve('page', modulePageId, false(), true())"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="project/url"/></xsl:otherwise>
                </xsl:choose>
            </href>
            <width>300</width>
        </button>
    </xsl:template>
</xsl:stylesheet>
