<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:exslt="http://exslt.org/common"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:avatar="org.ametys.plugins.core.ui.user.ProfileImageResolverHelper">
    
    <!-- +
         | Common template for item 
         + -->
    <xsl:template match="item">
        <xsl:param name="width" select="$max-width - 60"/>
        <xsl:param name="padding-top">20</xsl:param>
        <xsl:param name="padding-bottom">5</xsl:param>
        <xsl:param name="padding-left">30</xsl:param>
        <xsl:param name="padding-right">30</xsl:param>
        
        <xsl:variable name="isLast" select="position() = last()"/>
        
        <xsl:apply-templates select="." mode="wrapper">
            <xsl:with-param name="width" select="$width"/>
            <xsl:with-param name="padding-top" select="$padding-top"/>
            <xsl:with-param name="padding-bottom" select="$padding-bottom"/>
            <xsl:with-param name="padding-left" select="$padding-left"/>
            <xsl:with-param name="padding-right" select="$padding-right"/>
            <xsl:with-param name="isLast" select="$isLast"/>
        </xsl:apply-templates>
        
        <xsl:apply-templates select="." mode="item-additional-content">
            <xsl:with-param name="isLast" select="$isLast"/>
        </xsl:apply-templates>
    </xsl:template>
                              
    <!-- +
         | Common template for item wrapper
         + -->
    <xsl:template match="item" mode="wrapper">
        <xsl:param name="width" select="$max-width - 60"/>
        <xsl:param name="padding-top">20</xsl:param>
        <xsl:param name="padding-bottom">5</xsl:param>
        <xsl:param name="padding-left">30</xsl:param>
        <xsl:param name="padding-right">30</xsl:param>
        <xsl:param name="isLast"/>
        
        <xsl:call-template name="msoif-open">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        
        <div style="max-width: {$width}px; margin: 0px auto;">
        
            <table>
                <xsl:call-template name="table-layout-attributes"/>
                <tbody>
                    <tr>
                        <td>
                            <xsl:call-template name="td-layout-attributes"/>
                            <table>
                                <xsl:call-template name="table-layout-attributes" />
                                <tbody>
                                    <xsl:call-template name="row-vertical-spacer">
                                        <xsl:with-param name="height" select="$padding-top"/>
                                        <xsl:with-param name="colspan">3</xsl:with-param>
                                    </xsl:call-template>
                                    <tr>
                                        <xsl:call-template name="row-horizontal-spacer">
                                            <xsl:with-param name="width" select="$padding-left"/>
                                        </xsl:call-template>
                                        <td>
                                            <xsl:attribute name="style">
                                                <xsl:text>direction: ltr; font-size: 0px; padding: 0px; word-break: break-word;</xsl:text>
                                                <xsl:if test="not($isLast)">
                                                    <xsl:apply-templates select="." mode="item-separator-style"/>
                                                </xsl:if>
                                            </xsl:attribute>
                                            <xsl:apply-templates select="." mode="item-content"/>
                                            
                                            <xsl:call-template name="table-vertical-spacer">
                                                <xsl:with-param name="height">20</xsl:with-param>
                                            </xsl:call-template>
                                        </td>
                                        <xsl:call-template name="row-horizontal-spacer">
                                            <xsl:with-param name="width" select="$padding-right"/>
                                        </xsl:call-template>
                                    </tr>
                                    <xsl:call-template name="row-vertical-spacer">
                                        <xsl:with-param name="height" select="$padding-bottom"/>
                                        <xsl:with-param name="colspan">3</xsl:with-param>
                                    </xsl:call-template>
                                </tbody>
                            </table>     
                        </td>
                    </tr>
                </tbody>
            </table>
         </div>
         <xsl:call-template name="msoif-close"/>
    </xsl:template>    
    
    <!-- +
         | Common template for item additional content. No additional content by default
         + -->
    <xsl:template match="item" mode="item-additional-content" priority="-1">
    </xsl:template> 
    
    <!-- +
         | Common template for item separator style. By default depends only on item position.
         + -->
    <xsl:template match="item" mode="item-separator-style" priority="-1">
        <xsl:text>border-bottom: 2px solid </xsl:text><xsl:value-of select="$separator-color"/><xsl:text>;</xsl:text>
    </xsl:template>
    
    <!-- +
         | Common template for item content
         + -->
    <xsl:template match="item" mode="item-content" priority="-1">
        <table align="left" border="0" cellpadding="0" cellspacing="0" role="presentation" style="border-collapse: collapse; border-spacing: 0px; width: 100%;">
            <tbody>
                <tr>
                    <td width="32" style="padding: 0px; direction: ltr; font-size: 0px; word-break: break-word;" valign="top">
                        <xsl:apply-templates select="." mode="item-icon"/>
                    </td>
                    <xsl:call-template name="row-horizontal-spacer">
                        <xsl:with-param name="width">5</xsl:with-param>
                    </xsl:call-template>
                    <td style="direction: ltr; font-size: 0px; padding: 0px; word-break: break-word;">
                        <xsl:call-template name="table-vertical-spacer">
                            <xsl:with-param name="height">0</xsl:with-param>
                        </xsl:call-template>
                        <xsl:apply-templates select="." mode="item-title"/>
                        <xsl:apply-templates select="." mode="item-details"/>
                    </td>
                </tr>
            </tbody>
        </table>
    </xsl:template>
    
    <!-- +
         | Common template for item title
         + -->
    <xsl:template match="item" mode="item-title" priority="-1">
        <div style="line-height: 1.4; font-size: 14px; font-family: {$font-family}; color: {$text-color-dark}; font-weight:500;">
            <xsl:value-of select="title"/>
        </div>
    </xsl:template>    
    
    <!-- +
         | Common template for item icon in 30x30 pixels
         + -->
    <xsl:template match="item" mode="item-icon" priority="-1">
        <xsl:param name="iconName">icon-question</xsl:param>
        
        <div style="width: 30px; height: 30px; display: inline-block;">
            <img width="30" height="30" src="{ametys:pluginImageBase64('workspaces', concat('img/mail/', $iconName, '.png'))}" alt="" style="display: block; border: 0; outline: none; text-decoration: none;"></img>
        </div>
    </xsl:template>
    
    <!-- +
         | Common template for item details as such "Created by XXX, the MMM dd yyyy"
         + -->
    <xsl:template match="item" mode="item-details" priority="-1">
        <xsl:param name="date" select="lastModified"/>
        <xsl:param name="author" select="author"/>
        
        <xsl:variable name="multipleSuffix"><xsl:if test="multiple = 'true'">S</xsl:if></xsl:variable>
        <!-- When aggregated, if there were multiple author, they are removed -->
        <xsl:variable name="authorInfo">
            <xsl:choose>
                <!-- We remove the author when multiple user made the same action -->
                <xsl:when test="multiple = 'true' and not($author)">_MULTIPLE_AUTHOR</xsl:when>
                <!-- If the user doesn't exist anymore or doesn't have a full name… -->
                <xsl:when test="$author and not($author/fullname)">_NO_AUTHOR</xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="detail">
            <i18n:translate>
                <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_BODY_{eventType}_ITEM{$multipleSuffix}_DETAIL{$authorInfo}" i18n:catalogue="plugin.workspaces"/>
                <i18n:param name="date"><i18n:date type="date" pattern="long" src-pattern="yyyy-MM-dd"><xsl:value-of select="$date"/></i18n:date></i18n:param>
                <i18n:param name="issuerFullname"><xsl:value-of select="$author/fullname"/></i18n:param>
            </i18n:translate>
        </xsl:variable>
        
        <div style="line-height: 1.4; font-size: 12px; font-family: {$font-family}; color: {$text-color-dark}; font-weight:300;">
            <i18n:translate>
                <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_BODY_{eventType}_ITEM{$multipleSuffix}_DETAIL{$authorInfo}" i18n:catalogue="plugin.workspaces"/>
                <i18n:param name="date"><i18n:date type="date" pattern="long" src-pattern="yyyy-MM-dd"><xsl:value-of select="$date"/></i18n:date></i18n:param>
                <i18n:param name="issuerFullname"><xsl:value-of select="$author/fullname"/></i18n:param>
            </i18n:translate>
        </div>
    </xsl:template>
    
    <xsl:template match="item" mode="item-additional-content" priority="-1"/>
    
    <xsl:template match="comment">
        <xsl:param name="level" select="1"/>
        
        <xsl:call-template name="comment">
            <xsl:with-param name="new" select="@new"/>
            <xsl:with-param name="author" select="author"/>
            <xsl:with-param name="content">
                <xsl:call-template name="text.nl2br">
                    <xsl:with-param name="input" select="content"/>
                </xsl:call-template>
            </xsl:with-param>
            <xsl:with-param name="date" select="datetime"/>
            <xsl:with-param name="level" select="$level"/>
            <xsl:with-param name="border-bottom" select="position() != last() or sub-comments/comment"/>
            <xsl:with-param name="accepted" select="accepted"/>
        </xsl:call-template>
        
        <xsl:variable name="commentId" select="id"/>
        <xsl:apply-templates select="sub-comments/comment">
            <xsl:sort select="datetime"/>
            <xsl:with-param name="level" select="$level + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    
</xsl:stylesheet>