/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.activities.documents;

import java.util.Map;

import javax.jcr.RepositoryException;

import org.ametys.plugins.explorer.ObservationConstants;
import org.ametys.plugins.explorer.resources.jcr.JCRResource;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.plugins.workspaces.activities.documents.ResourceReferenceElementType.ResourceReference;

/**
 * {@link ActivityType} implementation for the creation of a resource 
 */
public class ResourceRenamedActivityType extends DocumentsActivityType
{
    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException
    {
        super.setAdditionalActivityData(activity, parameters);
        
        // File data
        String resourceName = (String) parameters.get(ObservationConstants.ARGS_NAME);
        String resourceOldName = (String) parameters.get("object.old.name");
        String resourceId = (String) parameters.get(ObservationConstants.ARGS_ID);
        
        // Store a reference to the version of the node instead of on the node itself
        JCRResource resource = (JCRResource) _ametysObjectResolver.resolveById(resourceId);
        activity.setValue(FILE_DATA_NAME, new ResourceReference(resourceId, resourceName, resourceOldName, resource.getMimeType(), null));
    }
}
