/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.dav;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

import org.ametys.core.authentication.AuthenticateAction;

/**
 * Action to get the token and the path from the URI/Header
 * the uri can be token/path/to/resource, or just path/to/resource if the token is in the X-Ametys-Token header
 */
public class GetTokenAndObjectPathAction extends AbstractAction
{
    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Map<String, String> result = new HashMap<>();
        
        Request request = ObjectModelHelper.getRequest(objectModel);
        String token = request.getHeader(AuthenticateAction.HEADER_TOKEN);
        
        String objectPath = parameters.getParameter("endUri", null);
        
        if (StringUtils.isBlank(token))
        {
            if (objectPath != null)
            {
                int posOfSlash = StringUtils.indexOf(objectPath, "/");
                if (posOfSlash > 0 && posOfSlash < objectPath.length() - 1) // if there is a slash, and it is not the last char
                {
                    token = objectPath.substring(0, posOfSlash);
                    objectPath = objectPath.substring(posOfSlash);
                }
            }
        }

        result.put("token", token);
        result.put("objectPath", objectPath);
        return result;
    }
}
